/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.CreateXMLClassifierRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateXMLClassifierRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, CreateXMLClassifierRequest> {
    private final String classification;
    private final String name;
    private final String rowTag;

    private CreateXMLClassifierRequest(BuilderImpl builder) {
        this.classification = builder.classification;
        this.name = builder.name;
        this.rowTag = builder.rowTag;
    }

    public String classification() {
        return this.classification;
    }

    public String name() {
        return this.name;
    }

    public String rowTag() {
        return this.rowTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateXMLClassifierRequest)) {
            return false;
        }
        CreateXMLClassifierRequest other = (CreateXMLClassifierRequest)obj;
        return Objects.equals(this.classification(), other.classification()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.rowTag(), other.rowTag());
    }

    public String toString() {
        return ToString.builder((String)"CreateXMLClassifierRequest").add("Classification", (Object)this.classification()).add("Name", (Object)this.name()).add("RowTag", (Object)this.rowTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RowTag": {
                return Optional.ofNullable(clazz.cast(this.rowTag()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateXMLClassifierRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String classification;
        private String name;
        private String rowTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateXMLClassifierRequest model) {
            this.classification(model.classification);
            this.name(model.name);
            this.rowTag(model.rowTag);
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRowTag() {
            return this.rowTag;
        }

        @Override
        public final Builder rowTag(String rowTag) {
            this.rowTag = rowTag;
            return this;
        }

        public final void setRowTag(String rowTag) {
            this.rowTag = rowTag;
        }

        public CreateXMLClassifierRequest build() {
            return new CreateXMLClassifierRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateXMLClassifierRequest> {
        public Builder classification(String var1);

        public Builder name(String var1);

        public Builder rowTag(String var1);
    }
}

