/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.CodeGenNodeArgMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeGenNodeArg
implements StructuredPojo,
ToCopyableBuilder<Builder, CodeGenNodeArg> {
    private final String name;
    private final String value;
    private final Boolean param;

    private CodeGenNodeArg(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.param = builder.param;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Boolean param() {
        return this.param;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.param());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeGenNodeArg)) {
            return false;
        }
        CodeGenNodeArg other = (CodeGenNodeArg)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.param(), other.param());
    }

    public String toString() {
        return ToString.builder((String)"CodeGenNodeArg").add("Name", (Object)this.name()).add("Value", (Object)this.value()).add("Param", (Object)this.param()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Param": {
                return Optional.ofNullable(clazz.cast(this.param()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeGenNodeArgMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;
        private Boolean param;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeGenNodeArg model) {
            this.name(model.name);
            this.value(model.value);
            this.param(model.param);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getParam() {
            return this.param;
        }

        @Override
        public final Builder param(Boolean param) {
            this.param = param;
            return this;
        }

        public final void setParam(Boolean param) {
            this.param = param;
        }

        public CodeGenNodeArg build() {
            return new CodeGenNodeArg(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeGenNodeArg> {
        public Builder name(String var1);

        public Builder value(String var1);

        public Builder param(Boolean var1);
    }
}

