/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.UpdateClassifierRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateClassifierRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> GROKCLASSIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrokClassifier").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> XMLCLASSIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XMLClassifier").isBinary(false).build();
    private static final UpdateClassifierRequestModelMarshaller INSTANCE = new UpdateClassifierRequestModelMarshaller();

    private UpdateClassifierRequestModelMarshaller() {
    }

    public static UpdateClassifierRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateClassifierRequest updateClassifierRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateClassifierRequest), (String)"updateClassifierRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateClassifierRequest.grokClassifier(), GROKCLASSIFIER_BINDING);
            protocolMarshaller.marshall((Object)updateClassifierRequest.xmlClassifier(), XMLCLASSIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

