/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.Schedule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScheduleMarshaller {
    private static final MarshallingInfo<String> SCHEDULEEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduleExpression").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final ScheduleMarshaller INSTANCE = new ScheduleMarshaller();

    private ScheduleMarshaller() {
    }

    public static ScheduleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Schedule schedule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)schedule, (String)"schedule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)schedule.scheduleExpression(), SCHEDULEEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)schedule.stateAsString(), STATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

