/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.Order;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OrderMarshaller {
    private static final MarshallingInfo<String> COLUMN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Column").isBinary(false).build();
    private static final MarshallingInfo<Integer> SORTORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortOrder").isBinary(false).build();
    private static final OrderMarshaller INSTANCE = new OrderMarshaller();

    private OrderMarshaller() {
    }

    public static OrderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Order order, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)order, (String)"order");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)order.column(), COLUMN_BINDING);
            protocolMarshaller.marshall((Object)order.sortOrder(), SORTORDER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

