/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.Location;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LocationMarshaller {
    private static final MarshallingInfo<List> JDBC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Jdbc").isBinary(false).build();
    private static final MarshallingInfo<List> S3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3").isBinary(false).build();
    private static final LocationMarshaller INSTANCE = new LocationMarshaller();

    private LocationMarshaller() {
    }

    public static LocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Location location, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)location, (String)"location");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(location.jdbc(), JDBC_BINDING);
            protocolMarshaller.marshall(location.s3(), S3_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

