/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.GrokClassifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GrokClassifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").isBinary(false).build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<String> GROKPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrokPattern").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomPatterns").isBinary(false).build();
    private static final GrokClassifierMarshaller INSTANCE = new GrokClassifierMarshaller();

    private GrokClassifierMarshaller() {
    }

    public static GrokClassifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GrokClassifier grokClassifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)grokClassifier, (String)"grokClassifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)grokClassifier.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.lastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.grokPattern(), GROKPATTERN_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.customPatterns(), CUSTOMPATTERNS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

