/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.DevEndpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DevEndpointMarshaller {
    private static final MarshallingInfo<String> ENDPOINTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointName").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> YARNENDPOINTADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("YarnEndpointAddress").isBinary(false).build();
    private static final MarshallingInfo<Integer> ZEPPELINREMOTESPARKINTERPRETERPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZeppelinRemoteSparkInterpreterPort").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicAddress").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFNODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfNodes").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").isBinary(false).build();
    private static final MarshallingInfo<String> EXTRAPYTHONLIBSS3PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraPythonLibsS3Path").isBinary(false).build();
    private static final MarshallingInfo<String> EXTRAJARSS3PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraJarsS3Path").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").isBinary(false).build();
    private static final MarshallingInfo<String> LASTUPDATESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").isBinary(false).build();
    private static final DevEndpointMarshaller INSTANCE = new DevEndpointMarshaller();

    private DevEndpointMarshaller() {
    }

    public static DevEndpointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DevEndpoint devEndpoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)devEndpoint, (String)"devEndpoint");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)devEndpoint.endpointName(), ENDPOINTNAME_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(devEndpoint.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.yarnEndpointAddress(), YARNENDPOINTADDRESS_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.zeppelinRemoteSparkInterpreterPort(), ZEPPELINREMOTESPARKINTERPRETERPORT_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.publicAddress(), PUBLICADDRESS_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.numberOfNodes(), NUMBEROFNODES_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.extraPythonLibsS3Path(), EXTRAPYTHONLIBSS3PATH_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.extraJarsS3Path(), EXTRAJARSS3PATH_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.failureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.lastUpdateStatus(), LASTUPDATESTATUS_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.lastModifiedTimestamp(), LASTMODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)devEndpoint.publicKey(), PUBLICKEY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

