/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.CrawlerMetrics;

public class CrawlerMetricsUnmarshaller
implements Unmarshaller<CrawlerMetrics, JsonUnmarshallerContext> {
    private static final CrawlerMetricsUnmarshaller INSTANCE = new CrawlerMetricsUnmarshaller();

    public CrawlerMetrics unmarshall(JsonUnmarshallerContext context) throws Exception {
        CrawlerMetrics.Builder crawlerMetricsBuilder = CrawlerMetrics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CrawlerName", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.crawlerName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TimeLeftSeconds", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.timeLeftSeconds((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("StillEstimating", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.stillEstimating((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastRuntimeSeconds", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.lastRuntimeSeconds((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("MedianRuntimeSeconds", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.medianRuntimeSeconds((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("TablesCreated", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.tablesCreated((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("TablesUpdated", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.tablesUpdated((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("TablesDeleted", targetDepth)) {
                    context.nextToken();
                    crawlerMetricsBuilder.tablesDeleted((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CrawlerMetrics)crawlerMetricsBuilder.build();
    }

    public static CrawlerMetricsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

