/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.ConnectionInput;
import software.amazon.awssdk.services.glue.transform.PhysicalConnectionRequirementsUnmarshaller;

public class ConnectionInputUnmarshaller
implements Unmarshaller<ConnectionInput, JsonUnmarshallerContext> {
    private static final ConnectionInputUnmarshaller INSTANCE = new ConnectionInputUnmarshaller();

    public ConnectionInput unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConnectionInput.Builder connectionInputBuilder = ConnectionInput.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    connectionInputBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    connectionInputBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConnectionType", targetDepth)) {
                    context.nextToken();
                    connectionInputBuilder.connectionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MatchCriteria", targetDepth)) {
                    context.nextToken();
                    connectionInputBuilder.matchCriteria(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ConnectionProperties", targetDepth)) {
                    context.nextToken();
                    connectionInputBuilder.connectionPropertiesWithStrings(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("PhysicalConnectionRequirements", targetDepth)) {
                    context.nextToken();
                    connectionInputBuilder.physicalConnectionRequirements(PhysicalConnectionRequirementsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ConnectionInput)connectionInputBuilder.build();
    }

    public static ConnectionInputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

