/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.ConnectionInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConnectionInputMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> CONNECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionType").isBinary(false).build();
    private static final MarshallingInfo<List> MATCHCRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchCriteria").isBinary(false).build();
    private static final MarshallingInfo<Map> CONNECTIONPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionProperties").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PHYSICALCONNECTIONREQUIREMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhysicalConnectionRequirements").isBinary(false).build();
    private static final ConnectionInputMarshaller INSTANCE = new ConnectionInputMarshaller();

    private ConnectionInputMarshaller() {
    }

    public static ConnectionInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConnectionInput connectionInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)connectionInput, (String)"connectionInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)connectionInput.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)connectionInput.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)connectionInput.connectionTypeAsString(), CONNECTIONTYPE_BINDING);
            protocolMarshaller.marshall(connectionInput.matchCriteria(), MATCHCRITERIA_BINDING);
            protocolMarshaller.marshall(connectionInput.connectionPropertiesAsStrings(), CONNECTIONPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)connectionInput.physicalConnectionRequirements(), PHYSICALCONNECTIONREQUIREMENTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

