/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchStopJobRunErrorMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobRunId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ERRORDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorDetail").isBinary(false).build();
    private static final BatchStopJobRunErrorMarshaller INSTANCE = new BatchStopJobRunErrorMarshaller();

    private BatchStopJobRunErrorMarshaller() {
    }

    public static BatchStopJobRunErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchStopJobRunError batchStopJobRunError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchStopJobRunError, (String)"batchStopJobRunError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchStopJobRunError.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)batchStopJobRunError.jobRunId(), JOBRUNID_BINDING);
            protocolMarshaller.marshall((Object)batchStopJobRunError.errorDetail(), ERRORDETAIL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

