/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;

public class GetDevEndpointsIterable
implements SdkIterable<GetDevEndpointsResponse> {
    private final GlueClient client;
    private final GetDevEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDevEndpointsIterable(GlueClient client, GetDevEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDevEndpointsResponseFetcher();
    }

    public Iterator<GetDevEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetDevEndpointsIterable resume(GetDevEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetDevEndpointsIterable(this.client, (GetDevEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetDevEndpointsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetDevEndpointsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetDevEndpointsResponseFetcher
    implements SyncPageFetcher<GetDevEndpointsResponse> {
        private GetDevEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(GetDevEndpointsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetDevEndpointsResponse nextPage(GetDevEndpointsResponse previousPage) {
            if (previousPage == null) {
                return GetDevEndpointsIterable.this.client.getDevEndpoints(GetDevEndpointsIterable.this.firstRequest);
            }
            return GetDevEndpointsIterable.this.client.getDevEndpoints((GetDevEndpointsRequest)((Object)GetDevEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

