/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;

public class GetCrawlerMetricsIterable
implements SdkIterable<GetCrawlerMetricsResponse> {
    private final GlueClient client;
    private final GetCrawlerMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCrawlerMetricsIterable(GlueClient client, GetCrawlerMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCrawlerMetricsResponseFetcher();
    }

    public Iterator<GetCrawlerMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetCrawlerMetricsIterable resume(GetCrawlerMetricsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCrawlerMetricsIterable(this.client, (GetCrawlerMetricsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCrawlerMetricsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetCrawlerMetricsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetCrawlerMetricsResponseFetcher
    implements SyncPageFetcher<GetCrawlerMetricsResponse> {
        private GetCrawlerMetricsResponseFetcher() {
        }

        public boolean hasNextPage(GetCrawlerMetricsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetCrawlerMetricsResponse nextPage(GetCrawlerMetricsResponse previousPage) {
            if (previousPage == null) {
                return GetCrawlerMetricsIterable.this.client.getCrawlerMetrics(GetCrawlerMetricsIterable.this.firstRequest);
            }
            return GetCrawlerMetricsIterable.this.client.getCrawlerMetrics((GetCrawlerMetricsRequest)((Object)GetCrawlerMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

