/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatabaseRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateDatabaseRequest> {
    private final String catalogId;
    private final String name;
    private final DatabaseInput databaseInput;

    private UpdateDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.name = builder.name;
        this.databaseInput = builder.databaseInput;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String name() {
        return this.name;
    }

    public DatabaseInput databaseInput() {
        return this.databaseInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatabaseRequest)) {
            return false;
        }
        UpdateDatabaseRequest other = (UpdateDatabaseRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.databaseInput(), other.databaseInput());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDatabaseRequest").add("CatalogId", (Object)this.catalogId()).add("Name", (Object)this.name()).add("DatabaseInput", (Object)this.databaseInput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DatabaseInput": {
                return Optional.ofNullable(clazz.cast(this.databaseInput()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String name;
        private DatabaseInput databaseInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatabaseRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.name(model.name);
            this.databaseInput(model.databaseInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final DatabaseInput.Builder getDatabaseInput() {
            return this.databaseInput != null ? this.databaseInput.toBuilder() : null;
        }

        @Override
        public final Builder databaseInput(DatabaseInput databaseInput) {
            this.databaseInput = databaseInput;
            return this;
        }

        public final void setDatabaseInput(DatabaseInput.BuilderImpl databaseInput) {
            this.databaseInput = databaseInput != null ? databaseInput.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatabaseRequest build() {
            return new UpdateDatabaseRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, UpdateDatabaseRequest> {
        public Builder catalogId(String var1);

        public Builder name(String var1);

        public Builder databaseInput(DatabaseInput var1);

        default public Builder databaseInput(Consumer<DatabaseInput.Builder> databaseInput) {
            return this.databaseInput((DatabaseInput)((DatabaseInput.Builder)DatabaseInput.builder().applyMutation(databaseInput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

