/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCrawlerScheduleRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateCrawlerScheduleRequest> {
    private final String crawlerName;
    private final String schedule;

    private UpdateCrawlerScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.crawlerName = builder.crawlerName;
        this.schedule = builder.schedule;
    }

    public String crawlerName() {
        return this.crawlerName;
    }

    public String schedule() {
        return this.schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCrawlerScheduleRequest)) {
            return false;
        }
        UpdateCrawlerScheduleRequest other = (UpdateCrawlerScheduleRequest)((Object)obj);
        return Objects.equals(this.crawlerName(), other.crawlerName()) && Objects.equals(this.schedule(), other.schedule());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCrawlerScheduleRequest").add("CrawlerName", (Object)this.crawlerName()).add("Schedule", (Object)this.schedule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlerName": {
                return Optional.ofNullable(clazz.cast(this.crawlerName()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String crawlerName;
        private String schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCrawlerScheduleRequest model) {
            super(model);
            this.crawlerName(model.crawlerName);
            this.schedule(model.schedule);
        }

        public final String getCrawlerName() {
            return this.crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCrawlerScheduleRequest build() {
            return new UpdateCrawlerScheduleRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, UpdateCrawlerScheduleRequest> {
        public Builder crawlerName(String var1);

        public Builder schedule(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

