/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTablesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetTablesResponse> {
    private final List<Table> tableList;
    private final String nextToken;

    private GetTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tableList = builder.tableList;
        this.nextToken = builder.nextToken;
    }

    public List<Table> tableList() {
        return this.tableList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTablesResponse)) {
            return false;
        }
        GetTablesResponse other = (GetTablesResponse)((Object)obj);
        return Objects.equals(this.tableList(), other.tableList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTablesResponse").add("TableList", this.tableList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableList": {
                return Optional.ofNullable(clazz.cast(this.tableList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Table> tableList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTablesResponse model) {
            super(model);
            this.tableList(model.tableList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Table.Builder> getTableList() {
            return this.tableList != null ? (Collection)this.tableList.stream().map(Table::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableList(Collection<Table> tableList) {
            this.tableList = TableListCopier.copy(tableList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableList(Table ... tableList) {
            this.tableList(Arrays.asList(tableList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableList(Consumer<Table.Builder> ... tableList) {
            this.tableList(Stream.of(tableList).map(c -> (Table)((Table.Builder)Table.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTableList(Collection<Table.BuilderImpl> tableList) {
            this.tableList = TableListCopier.copyFromBuilder(tableList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTablesResponse build() {
            return new GetTablesResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetTablesResponse> {
        public Builder tableList(Collection<Table> var1);

        public Builder tableList(Table ... var1);

        public Builder tableList(Consumer<Table.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

