/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ClassifierNameListCopier;
import software.amazon.awssdk.services.glue.model.CrawlerTargets;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SchemaChangePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCrawlerRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateCrawlerRequest> {
    private final String name;
    private final String role;
    private final String databaseName;
    private final String description;
    private final CrawlerTargets targets;
    private final String schedule;
    private final List<String> classifiers;
    private final String tablePrefix;
    private final SchemaChangePolicy schemaChangePolicy;
    private final String configuration;

    private CreateCrawlerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.role = builder.role;
        this.databaseName = builder.databaseName;
        this.description = builder.description;
        this.targets = builder.targets;
        this.schedule = builder.schedule;
        this.classifiers = builder.classifiers;
        this.tablePrefix = builder.tablePrefix;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.configuration = builder.configuration;
    }

    public String name() {
        return this.name;
    }

    public String role() {
        return this.role;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String description() {
        return this.description;
    }

    public CrawlerTargets targets() {
        return this.targets;
    }

    public String schedule() {
        return this.schedule;
    }

    public List<String> classifiers() {
        return this.classifiers;
    }

    public String tablePrefix() {
        return this.tablePrefix;
    }

    public SchemaChangePolicy schemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public String configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCrawlerRequest)) {
            return false;
        }
        CreateCrawlerRequest other = (CreateCrawlerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.classifiers(), other.classifiers()) && Objects.equals(this.tablePrefix(), other.tablePrefix()) && Objects.equals(this.schemaChangePolicy(), other.schemaChangePolicy()) && Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        return ToString.builder((String)"CreateCrawlerRequest").add("Name", (Object)this.name()).add("Role", (Object)this.role()).add("DatabaseName", (Object)this.databaseName()).add("Description", (Object)this.description()).add("Targets", (Object)this.targets()).add("Schedule", (Object)this.schedule()).add("Classifiers", this.classifiers()).add("TablePrefix", (Object)this.tablePrefix()).add("SchemaChangePolicy", (Object)this.schemaChangePolicy()).add("Configuration", (Object)this.configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Classifiers": {
                return Optional.ofNullable(clazz.cast(this.classifiers()));
            }
            case "TablePrefix": {
                return Optional.ofNullable(clazz.cast(this.tablePrefix()));
            }
            case "SchemaChangePolicy": {
                return Optional.ofNullable(clazz.cast(this.schemaChangePolicy()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String role;
        private String databaseName;
        private String description;
        private CrawlerTargets targets;
        private String schedule;
        private List<String> classifiers = DefaultSdkAutoConstructList.getInstance();
        private String tablePrefix;
        private SchemaChangePolicy schemaChangePolicy;
        private String configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCrawlerRequest model) {
            super(model);
            this.name(model.name);
            this.role(model.role);
            this.databaseName(model.databaseName);
            this.description(model.description);
            this.targets(model.targets);
            this.schedule(model.schedule);
            this.classifiers(model.classifiers);
            this.tablePrefix(model.tablePrefix);
            this.schemaChangePolicy(model.schemaChangePolicy);
            this.configuration(model.configuration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final CrawlerTargets.Builder getTargets() {
            return this.targets != null ? this.targets.toBuilder() : null;
        }

        @Override
        public final Builder targets(CrawlerTargets targets) {
            this.targets = targets;
            return this;
        }

        public final void setTargets(CrawlerTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Collection<String> getClassifiers() {
            return this.classifiers;
        }

        @Override
        public final Builder classifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(String ... classifiers) {
            this.classifiers(Arrays.asList(classifiers));
            return this;
        }

        public final void setClassifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
        }

        public final String getTablePrefix() {
            return this.tablePrefix;
        }

        @Override
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        public final SchemaChangePolicy.Builder getSchemaChangePolicy() {
            return this.schemaChangePolicy != null ? this.schemaChangePolicy.toBuilder() : null;
        }

        @Override
        public final Builder schemaChangePolicy(SchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final void setSchemaChangePolicy(SchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCrawlerRequest build() {
            return new CreateCrawlerRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, CreateCrawlerRequest> {
        public Builder name(String var1);

        public Builder role(String var1);

        public Builder databaseName(String var1);

        public Builder description(String var1);

        public Builder targets(CrawlerTargets var1);

        default public Builder targets(Consumer<CrawlerTargets.Builder> targets) {
            return this.targets((CrawlerTargets)((CrawlerTargets.Builder)CrawlerTargets.builder().applyMutation(targets)).build());
        }

        public Builder schedule(String var1);

        public Builder classifiers(Collection<String> var1);

        public Builder classifiers(String ... var1);

        public Builder tablePrefix(String var1);

        public Builder schemaChangePolicy(SchemaChangePolicy var1);

        default public Builder schemaChangePolicy(Consumer<SchemaChangePolicy.Builder> schemaChangePolicy) {
            return this.schemaChangePolicy((SchemaChangePolicy)((SchemaChangePolicy.Builder)SchemaChangePolicy.builder().applyMutation(schemaChangePolicy)).build());
        }

        public Builder configuration(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

