/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.StringListCopier;
import software.amazon.awssdk.services.glue.transform.ConnectionsListMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionsList
implements StructuredPojo,
ToCopyableBuilder<Builder, ConnectionsList> {
    private final List<String> connections;

    private ConnectionsList(BuilderImpl builder) {
        this.connections = builder.connections;
    }

    public List<String> connections() {
        return this.connections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionsList)) {
            return false;
        }
        ConnectionsList other = (ConnectionsList)obj;
        return Objects.equals(this.connections(), other.connections());
    }

    public String toString() {
        return ToString.builder((String)"ConnectionsList").add("Connections", this.connections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionsListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> connections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionsList model) {
            this.connections(model.connections);
        }

        public final Collection<String> getConnections() {
            return this.connections;
        }

        @Override
        public final Builder connections(Collection<String> connections) {
            this.connections = StringListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(String ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        public final void setConnections(Collection<String> connections) {
            this.connections = StringListCopier.copy(connections);
        }

        public ConnectionsList build() {
            return new ConnectionsList(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConnectionsList> {
        public Builder connections(Collection<String> var1);

        public Builder connections(String ... var1);
    }
}

