/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetTablesRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> EXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expression").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final GetTablesRequestModelMarshaller INSTANCE = new GetTablesRequestModelMarshaller();

    private GetTablesRequestModelMarshaller() {
    }

    public static GetTablesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetTablesRequest getTablesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getTablesRequest), (String)"getTablesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getTablesRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)getTablesRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)getTablesRequest.expression(), EXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)getTablesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)getTablesRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

