/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDeleteConnectionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<List> CONNECTIONNAMELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionNameList").isBinary(false).build();
    private static final BatchDeleteConnectionRequestModelMarshaller INSTANCE = new BatchDeleteConnectionRequestModelMarshaller();

    private BatchDeleteConnectionRequestModelMarshaller() {
    }

    public static BatchDeleteConnectionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDeleteConnectionRequest batchDeleteConnectionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchDeleteConnectionRequest), (String)"batchDeleteConnectionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchDeleteConnectionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall(batchDeleteConnectionRequest.connectionNameList(), CONNECTIONNAMELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

