/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;

public class GetUserDefinedFunctionsPublisher
implements SdkPublisher<GetUserDefinedFunctionsResponse> {
    private final GlueAsyncClient client;
    private final GetUserDefinedFunctionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUserDefinedFunctionsPublisher(GlueAsyncClient client, GetUserDefinedFunctionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUserDefinedFunctionsPublisher(GlueAsyncClient client, GetUserDefinedFunctionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUserDefinedFunctionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUserDefinedFunctionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetUserDefinedFunctionsPublisher resume(GetUserDefinedFunctionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetUserDefinedFunctionsPublisher(this.client, (GetUserDefinedFunctionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetUserDefinedFunctionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetUserDefinedFunctionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetUserDefinedFunctionsResponseFetcher
    implements AsyncPageFetcher<GetUserDefinedFunctionsResponse> {
        private GetUserDefinedFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(GetUserDefinedFunctionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetUserDefinedFunctionsResponse> nextPage(GetUserDefinedFunctionsResponse previousPage) {
            if (previousPage == null) {
                return GetUserDefinedFunctionsPublisher.this.client.getUserDefinedFunctions(GetUserDefinedFunctionsPublisher.this.firstRequest);
            }
            return GetUserDefinedFunctionsPublisher.this.client.getUserDefinedFunctions((GetUserDefinedFunctionsRequest)((Object)GetUserDefinedFunctionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

