/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;

public class GetDatabasesPublisher
implements SdkPublisher<GetDatabasesResponse> {
    private final GlueAsyncClient client;
    private final GetDatabasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDatabasesPublisher(GlueAsyncClient client, GetDatabasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDatabasesPublisher(GlueAsyncClient client, GetDatabasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDatabasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDatabasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetDatabasesPublisher resume(GetDatabasesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetDatabasesPublisher(this.client, (GetDatabasesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetDatabasesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetDatabasesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetDatabasesResponseFetcher
    implements AsyncPageFetcher<GetDatabasesResponse> {
        private GetDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(GetDatabasesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetDatabasesResponse> nextPage(GetDatabasesResponse previousPage) {
            if (previousPage == null) {
                return GetDatabasesPublisher.this.client.getDatabases(GetDatabasesPublisher.this.firstRequest);
            }
            return GetDatabasesPublisher.this.client.getDatabases((GetDatabasesRequest)((Object)GetDatabasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

