/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.JobUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateJobRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateJobRequest> {
    private final String jobName;
    private final JobUpdate jobUpdate;

    private UpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobUpdate = builder.jobUpdate;
    }

    public String jobName() {
        return this.jobName;
    }

    public JobUpdate jobUpdate() {
        return this.jobUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobRequest)) {
            return false;
        }
        UpdateJobRequest other = (UpdateJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobUpdate(), other.jobUpdate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateJobRequest").add("JobName", (Object)this.jobName()).add("JobUpdate", (Object)this.jobUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "JobUpdate": {
                return Optional.of(clazz.cast(this.jobUpdate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private JobUpdate jobUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobUpdate(model.jobUpdate);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final JobUpdate.Builder getJobUpdate() {
            return this.jobUpdate != null ? this.jobUpdate.toBuilder() : null;
        }

        @Override
        public final Builder jobUpdate(JobUpdate jobUpdate) {
            this.jobUpdate = jobUpdate;
            return this;
        }

        public final void setJobUpdate(JobUpdate.BuilderImpl jobUpdate) {
            this.jobUpdate = jobUpdate != null ? jobUpdate.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, UpdateJobRequest> {
        public Builder jobName(String var1);

        public Builder jobUpdate(JobUpdate var1);

        default public Builder jobUpdate(Consumer<JobUpdate.Builder> jobUpdate) {
            return this.jobUpdate((JobUpdate)((JobUpdate.Builder)JobUpdate.builder().apply(jobUpdate)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

