/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.CatalogEntriesCopier;
import software.amazon.awssdk.services.glue.model.CatalogEntry;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.Location;
import software.amazon.awssdk.services.glue.model.MappingEntry;
import software.amazon.awssdk.services.glue.model.MappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPlanRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetPlanRequest> {
    private final List<MappingEntry> mapping;
    private final CatalogEntry source;
    private final List<CatalogEntry> sinks;
    private final Location location;

    private GetPlanRequest(BuilderImpl builder) {
        super(builder);
        this.mapping = builder.mapping;
        this.source = builder.source;
        this.sinks = builder.sinks;
        this.location = builder.location;
    }

    public List<MappingEntry> mapping() {
        return this.mapping;
    }

    public CatalogEntry source() {
        return this.source;
    }

    public List<CatalogEntry> sinks() {
        return this.sinks;
    }

    public Location location() {
        return this.location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanRequest)) {
            return false;
        }
        GetPlanRequest other = (GetPlanRequest)((Object)obj);
        return Objects.equals(this.mapping(), other.mapping()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sinks(), other.sinks()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"GetPlanRequest").add("Mapping", this.mapping()).add("Source", (Object)this.source()).add("Sinks", this.sinks()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mapping": {
                return Optional.of(clazz.cast(this.mapping()));
            }
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "Sinks": {
                return Optional.of(clazz.cast(this.sinks()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<MappingEntry> mapping;
        private CatalogEntry source;
        private List<CatalogEntry> sinks;
        private Location location;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanRequest model) {
            super(model);
            this.mapping(model.mapping);
            this.source(model.source);
            this.sinks(model.sinks);
            this.location(model.location);
        }

        public final Collection<MappingEntry.Builder> getMapping() {
            return this.mapping != null ? (Collection)this.mapping.stream().map(MappingEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapping(Collection<MappingEntry> mapping) {
            this.mapping = MappingListCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(MappingEntry ... mapping) {
            this.mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<MappingEntry.Builder> ... mapping) {
            this.mapping(Stream.of(mapping).map(c -> (MappingEntry)((MappingEntry.Builder)MappingEntry.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapping(Collection<MappingEntry.BuilderImpl> mapping) {
            this.mapping = MappingListCopier.copyFromBuilder(mapping);
        }

        public final CatalogEntry.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(CatalogEntry source) {
            this.source = source;
            return this;
        }

        public final void setSource(CatalogEntry.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<CatalogEntry.Builder> getSinks() {
            return this.sinks != null ? (Collection)this.sinks.stream().map(CatalogEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sinks(Collection<CatalogEntry> sinks) {
            this.sinks = CatalogEntriesCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(CatalogEntry ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<CatalogEntry.Builder> ... sinks) {
            this.sinks(Stream.of(sinks).map(c -> (CatalogEntry)((CatalogEntry.Builder)CatalogEntry.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSinks(Collection<CatalogEntry.BuilderImpl> sinks) {
            this.sinks = CatalogEntriesCopier.copyFromBuilder(sinks);
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetPlanRequest build() {
            return new GetPlanRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, GetPlanRequest> {
        public Builder mapping(Collection<MappingEntry> var1);

        public Builder mapping(MappingEntry ... var1);

        public Builder mapping(Consumer<MappingEntry.Builder> ... var1);

        public Builder source(CatalogEntry var1);

        default public Builder source(Consumer<CatalogEntry.Builder> source) {
            return this.source((CatalogEntry)((CatalogEntry.Builder)CatalogEntry.builder().apply(source)).build());
        }

        public Builder sinks(Collection<CatalogEntry> var1);

        public Builder sinks(CatalogEntry ... var1);

        public Builder sinks(Consumer<CatalogEntry.Builder> ... var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().apply(location)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

