/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.MappingEntry;
import software.amazon.awssdk.services.glue.model.MappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMappingResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetMappingResponse> {
    private final List<MappingEntry> mapping;

    private GetMappingResponse(BuilderImpl builder) {
        super(builder);
        this.mapping = builder.mapping;
    }

    public List<MappingEntry> mapping() {
        return this.mapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mapping());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMappingResponse)) {
            return false;
        }
        GetMappingResponse other = (GetMappingResponse)((Object)obj);
        return Objects.equals(this.mapping(), other.mapping());
    }

    public String toString() {
        return ToString.builder((String)"GetMappingResponse").add("Mapping", this.mapping()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mapping": {
                return Optional.of(clazz.cast(this.mapping()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<MappingEntry> mapping;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMappingResponse model) {
            super(model);
            this.mapping(model.mapping);
        }

        public final Collection<MappingEntry.Builder> getMapping() {
            return this.mapping != null ? (Collection)this.mapping.stream().map(MappingEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapping(Collection<MappingEntry> mapping) {
            this.mapping = MappingListCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(MappingEntry ... mapping) {
            this.mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<MappingEntry.Builder> ... mapping) {
            this.mapping(Stream.of(mapping).map(c -> (MappingEntry)((MappingEntry.Builder)MappingEntry.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapping(Collection<MappingEntry.BuilderImpl> mapping) {
            this.mapping = MappingListCopier.copyFromBuilder(mapping);
        }

        @Override
        public GetMappingResponse build() {
            return new GetMappingResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetMappingResponse> {
        public Builder mapping(Collection<MappingEntry> var1);

        public Builder mapping(MappingEntry ... var1);

        public Builder mapping(Consumer<MappingEntry.Builder> ... var1);
    }
}

