/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteTableRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, DeleteTableRequest> {
    private final String catalogId;
    private final String databaseName;
    private final String name;

    private DeleteTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTableRequest)) {
            return false;
        }
        DeleteTableRequest other = (DeleteTableRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"DeleteTableRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTableRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.name(model.name);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteTableRequest build() {
            return new DeleteTableRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, DeleteTableRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder name(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

