/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.glue.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.services.glue.model.ConnectionPropertyKey;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.services.glue.model.MatchCriteriaCopier;
import software.amazon.awssdk.services.glue.model.PhysicalConnectionRequirements;
import software.amazon.awssdk.services.glue.transform.ConnectionInputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConnectionInput
implements StructuredPojo,
ToCopyableBuilder<Builder, ConnectionInput> {
    private final String name;
    private final String description;
    private final String connectionType;
    private final List<String> matchCriteria;
    private final Map<String, String> connectionProperties;
    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private ConnectionInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public String connectionTypeAsString() {
        return this.connectionType;
    }

    public List<String> matchCriteria() {
        return this.matchCriteria;
    }

    public Map<ConnectionPropertyKey, String> connectionProperties() {
        return TypeConverter.convert(this.connectionProperties, ConnectionPropertyKey::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)ConnectionPropertyKey.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> connectionPropertiesAsStrings() {
        return this.connectionProperties;
    }

    public PhysicalConnectionRequirements physicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPropertiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectionRequirements());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionInput)) {
            return false;
        }
        ConnectionInput other = (ConnectionInput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.matchCriteria(), other.matchCriteria()) && Objects.equals(this.connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings()) && Objects.equals(this.physicalConnectionRequirements(), other.physicalConnectionRequirements());
    }

    public String toString() {
        return ToString.builder((String)"ConnectionInput").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("MatchCriteria", this.matchCriteria()).add("ConnectionProperties", this.connectionPropertiesAsStrings()).add("PhysicalConnectionRequirements", (Object)this.physicalConnectionRequirements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ConnectionType": {
                return Optional.of(clazz.cast(this.connectionTypeAsString()));
            }
            case "MatchCriteria": {
                return Optional.of(clazz.cast(this.matchCriteria()));
            }
            case "ConnectionProperties": {
                return Optional.of(clazz.cast(this.connectionPropertiesAsStrings()));
            }
            case "PhysicalConnectionRequirements": {
                return Optional.of(clazz.cast(this.physicalConnectionRequirements()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String connectionType;
        private List<String> matchCriteria;
        private Map<String, String> connectionProperties;
        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionInput model) {
            this.name(model.name);
            this.description(model.description);
            this.connectionType(model.connectionType);
            this.matchCriteria(model.matchCriteria);
            this.connectionProperties(model.connectionProperties);
            this.physicalConnectionRequirements(model.physicalConnectionRequirements);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final Collection<String> getMatchCriteria() {
            return this.matchCriteria;
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String ... matchCriteria) {
            this.matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        public final Map<String, String> getConnectionProperties() {
            return this.connectionProperties;
        }

        @Override
        public final Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.toBuilder() : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final void setPhysicalConnectionRequirements(PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build() : null;
        }

        public ConnectionInput build() {
            return new ConnectionInput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConnectionInput> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder matchCriteria(Collection<String> var1);

        public Builder matchCriteria(String ... var1);

        public Builder connectionProperties(Map<String, String> var1);

        public Builder physicalConnectionRequirements(PhysicalConnectionRequirements var1);

        default public Builder physicalConnectionRequirements(Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return this.physicalConnectionRequirements((PhysicalConnectionRequirements)((PhysicalConnectionRequirements.Builder)PhysicalConnectionRequirements.builder().apply(physicalConnectionRequirements)).build());
        }
    }
}

