/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAccelerator;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;

public class ListCustomRoutingAcceleratorsPublisher
implements SdkPublisher<ListCustomRoutingAcceleratorsResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListCustomRoutingAcceleratorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomRoutingAcceleratorsPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingAcceleratorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomRoutingAcceleratorsPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingAcceleratorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomRoutingAcceleratorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomRoutingAcceleratorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomRoutingAccelerator> accelerators() {
        return this.flatMapIterable(response -> response.accelerators());
    }

    private class ListCustomRoutingAcceleratorsResponseFetcher
    implements AsyncPageFetcher<ListCustomRoutingAcceleratorsResponse> {
        private ListCustomRoutingAcceleratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingAcceleratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomRoutingAcceleratorsResponse> nextPage(ListCustomRoutingAcceleratorsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingAcceleratorsPublisher.this.client.listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsPublisher.this.firstRequest);
            }
            return ListCustomRoutingAcceleratorsPublisher.this.client.listCustomRoutingAccelerators((ListCustomRoutingAcceleratorsRequest)((Object)ListCustomRoutingAcceleratorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

