/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping;
import software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMappingsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomRoutingPortMappingsByDestinationResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListCustomRoutingPortMappingsByDestinationResponse> {
    private static final SdkField<List<DestinationPortMapping>> DESTINATION_PORT_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPortMappings").getter(ListCustomRoutingPortMappingsByDestinationResponse.getter(ListCustomRoutingPortMappingsByDestinationResponse::destinationPortMappings)).setter(ListCustomRoutingPortMappingsByDestinationResponse.setter(Builder::destinationPortMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationPortMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomRoutingPortMappingsByDestinationResponse.getter(ListCustomRoutingPortMappingsByDestinationResponse::nextToken)).setter(ListCustomRoutingPortMappingsByDestinationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PORT_MAPPINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCustomRoutingPortMappingsByDestinationResponse.memberNameToFieldInitializer();
    private final List<DestinationPortMapping> destinationPortMappings;
    private final String nextToken;

    private ListCustomRoutingPortMappingsByDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.destinationPortMappings = builder.destinationPortMappings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDestinationPortMappings() {
        return this.destinationPortMappings != null && !(this.destinationPortMappings instanceof SdkAutoConstructList);
    }

    public final List<DestinationPortMapping> destinationPortMappings() {
        return this.destinationPortMappings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPortMappings() ? this.destinationPortMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingPortMappingsByDestinationResponse)) {
            return false;
        }
        ListCustomRoutingPortMappingsByDestinationResponse other = (ListCustomRoutingPortMappingsByDestinationResponse)((Object)obj);
        return this.hasDestinationPortMappings() == other.hasDestinationPortMappings() && Objects.equals(this.destinationPortMappings(), other.destinationPortMappings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomRoutingPortMappingsByDestinationResponse").add("DestinationPortMappings", this.hasDestinationPortMappings() ? this.destinationPortMappings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPortMappings": {
                return Optional.ofNullable(clazz.cast(this.destinationPortMappings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationPortMappings", DESTINATION_PORT_MAPPINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingPortMappingsByDestinationResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingPortMappingsByDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<DestinationPortMapping> destinationPortMappings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingPortMappingsByDestinationResponse model) {
            super(model);
            this.destinationPortMappings(model.destinationPortMappings);
            this.nextToken(model.nextToken);
        }

        public final List<DestinationPortMapping.Builder> getDestinationPortMappings() {
            List<DestinationPortMapping.Builder> result = DestinationPortMappingsCopier.copyToBuilder(this.destinationPortMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationPortMappings(Collection<DestinationPortMapping.BuilderImpl> destinationPortMappings) {
            this.destinationPortMappings = DestinationPortMappingsCopier.copyFromBuilder(destinationPortMappings);
        }

        @Override
        public final Builder destinationPortMappings(Collection<DestinationPortMapping> destinationPortMappings) {
            this.destinationPortMappings = DestinationPortMappingsCopier.copy(destinationPortMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPortMappings(DestinationPortMapping ... destinationPortMappings) {
            this.destinationPortMappings(Arrays.asList(destinationPortMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPortMappings(Consumer<DestinationPortMapping.Builder> ... destinationPortMappings) {
            this.destinationPortMappings(Stream.of(destinationPortMappings).map(c -> (DestinationPortMapping)((DestinationPortMapping.Builder)DestinationPortMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingPortMappingsByDestinationResponse build() {
            return new ListCustomRoutingPortMappingsByDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomRoutingPortMappingsByDestinationResponse> {
        public Builder destinationPortMappings(Collection<DestinationPortMapping> var1);

        public Builder destinationPortMappings(DestinationPortMapping ... var1);

        public Builder destinationPortMappings(Consumer<DestinationPortMapping.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

