/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;

public class ListCustomRoutingEndpointGroupsIterable
implements SdkIterable<ListCustomRoutingEndpointGroupsResponse> {
    private final GlobalAcceleratorClient client;
    private final ListCustomRoutingEndpointGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomRoutingEndpointGroupsIterable(GlobalAcceleratorClient client, ListCustomRoutingEndpointGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomRoutingEndpointGroupsResponseFetcher();
    }

    public Iterator<ListCustomRoutingEndpointGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCustomRoutingEndpointGroupsResponseFetcher
    implements SyncPageFetcher<ListCustomRoutingEndpointGroupsResponse> {
        private ListCustomRoutingEndpointGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingEndpointGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomRoutingEndpointGroupsResponse nextPage(ListCustomRoutingEndpointGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingEndpointGroupsIterable.this.client.listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsIterable.this.firstRequest);
            }
            return ListCustomRoutingEndpointGroupsIterable.this.client.listCustomRoutingEndpointGroups((ListCustomRoutingEndpointGroupsRequest)((Object)ListCustomRoutingEndpointGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

