/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.Accelerator;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAcceleratorsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListAcceleratorsResponse> {
    private static final SdkField<List<Accelerator>> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAcceleratorsResponse.getter(ListAcceleratorsResponse::accelerators)).setter(ListAcceleratorsResponse.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Accelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAcceleratorsResponse.getter(ListAcceleratorsResponse::nextToken)).setter(ListAcceleratorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Accelerator> accelerators;
    private final String nextToken;

    private ListAcceleratorsResponse(BuilderImpl builder) {
        super(builder);
        this.accelerators = builder.accelerators;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAccelerators() {
        return this.accelerators != null && !(this.accelerators instanceof SdkAutoConstructList);
    }

    public List<Accelerator> accelerators() {
        return this.accelerators;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accelerators());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAcceleratorsResponse)) {
            return false;
        }
        ListAcceleratorsResponse other = (ListAcceleratorsResponse)((Object)obj);
        return Objects.equals(this.accelerators(), other.accelerators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAcceleratorsResponse").add("Accelerators", this.accelerators()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accelerators": {
                return Optional.ofNullable(clazz.cast(this.accelerators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAcceleratorsResponse, T> g) {
        return obj -> g.apply((ListAcceleratorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<Accelerator> accelerators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAcceleratorsResponse model) {
            super(model);
            this.accelerators(model.accelerators);
            this.nextToken(model.nextToken);
        }

        public final Collection<Accelerator.Builder> getAccelerators() {
            return this.accelerators != null ? (Collection)this.accelerators.stream().map(Accelerator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accelerators(Collection<Accelerator> accelerators) {
            this.accelerators = AcceleratorsCopier.copy(accelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Accelerator ... accelerators) {
            this.accelerators(Arrays.asList(accelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Consumer<Accelerator.Builder> ... accelerators) {
            this.accelerators(Stream.of(accelerators).map(c -> (Accelerator)((Accelerator.Builder)Accelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccelerators(Collection<Accelerator.BuilderImpl> accelerators) {
            this.accelerators = AcceleratorsCopier.copyFromBuilder(accelerators);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAcceleratorsResponse build() {
            return new ListAcceleratorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAcceleratorsResponse> {
        public Builder accelerators(Collection<Accelerator> var1);

        public Builder accelerators(Accelerator ... var1);

        public Builder accelerators(Consumer<Accelerator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

