/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListListenersResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<ListListenersResponse.Builder, ListListenersResponse> {
    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField
            .<List<Listener>> builder(MarshallingType.LIST)
            .getter(getter(ListListenersResponse::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Listener> builder(MarshallingType.SDK_POJO)
                                            .constructor(Listener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListListenersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Listener> listeners;

    private final String nextToken;

    private ListListenersResponse(BuilderImpl builder) {
        super(builder);
        this.listeners = builder.listeners;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Listeners property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of listeners for an accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasListeners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of listeners for an accelerator.
     */
    public List<Listener> listeners() {
        return listeners;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listeners());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListListenersResponse)) {
            return false;
        }
        ListListenersResponse other = (ListListenersResponse) obj;
        return Objects.equals(listeners(), other.listeners()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListListenersResponse").add("Listeners", listeners()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListListenersResponse, T> g) {
        return obj -> g.apply((ListListenersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListListenersResponse> {
        /**
         * <p>
         * The list of listeners for an accelerator.
         * </p>
         * 
         * @param listeners
         *        The list of listeners for an accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<Listener> listeners);

        /**
         * <p>
         * The list of listeners for an accelerator.
         * </p>
         * 
         * @param listeners
         *        The list of listeners for an accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Listener... listeners);

        /**
         * <p>
         * The list of listeners for an accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Listener>.Builder} avoiding the need to
         * create one manually via {@link List<Listener>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Listener>.Builder#build()} is called immediately and its
         * result is passed to {@link #listeners(List<Listener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on {@link List<Listener>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(List<Listener>)
         */
        Builder listeners(Consumer<Listener.Builder>... listeners);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListListenersResponse model) {
            super(model);
            listeners(model.listeners);
            nextToken(model.nextToken);
        }

        public final Collection<Listener.Builder> getListeners() {
            return listeners != null ? listeners.stream().map(Listener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> Listener.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListListenersResponse build() {
            return new ListListenersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
