/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type for endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointConfiguration.Builder, EndpointConfiguration> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointConfiguration::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EndpointConfiguration::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final SdkField<Boolean> CLIENT_IP_PRESERVATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EndpointConfiguration::clientIPPreservationEnabled))
            .setter(setter(Builder::clientIPPreservationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIPPreservationEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            WEIGHT_FIELD, CLIENT_IP_PRESERVATION_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final Integer weight;

    private final Boolean clientIPPreservationEnabled;

    private EndpointConfiguration(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.weight = builder.weight;
        this.clientIPPreservationEnabled = builder.clientIPPreservationEnabled;
    }

    /**
     * <p>
     * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the
     * Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP
     * address allocation ID. For EC2 instances, this is the EC2 instance ID.
     * </p>
     * <p>
     * An Application Load Balancer can be either internal or internet-facing.
     * </p>
     * 
     * @return An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is
     *         the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the
     *         Elastic IP address allocation ID. For EC2 instances, this is the EC2 instance ID. </p>
     *         <p>
     *         An Application Load Balancer can be either internal or internet-facing.
     */
    public String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator
     * to route traffic based on proportions that you specify. For example, you might specify endpoint weights of 4, 5,
     * 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is
     * routed both to the second and third endpoints, and 6/20 is routed to the last endpoint. For more information, see
     * <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint
     * Weights</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     * </p>
     * 
     * @return The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global
     *         Accelerator to route traffic based on proportions that you specify. For example, you might specify
     *         endpoint weights of 4, 5, 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is
     *         routed to the first endpoint, 5/20 is routed both to the second and third endpoints, and 6/20 is routed
     *         to the last endpoint. For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html"
     *         >Endpoint Weights</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     */
    public Integer weight() {
        return weight;
    }

    /**
     * <p>
     * Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint. The value
     * is true or false. The default value is true for new accelerators.
     * </p>
     * <p>
     * If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request
     * header as traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html"> Preserve Client
     * IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     * </p>
     * 
     * @return Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
     *         The value is true or false. The default value is true for new accelerators. </p>
     *         <p>
     *         If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code>
     *         request header as traffic travels to applications on the Application Load Balancer endpoint fronted by
     *         the accelerator.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html"> Preserve
     *         Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     */
    public Boolean clientIPPreservationEnabled() {
        return clientIPPreservationEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(clientIPPreservationEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration) obj;
        return Objects.equals(endpointId(), other.endpointId()) && Objects.equals(weight(), other.weight())
                && Objects.equals(clientIPPreservationEnabled(), other.clientIPPreservationEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EndpointConfiguration").add("EndpointId", endpointId()).add("Weight", weight())
                .add("ClientIPPreservationEnabled", clientIPPreservationEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "ClientIPPreservationEnabled":
            return Optional.ofNullable(clazz.cast(clientIPPreservationEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointConfiguration, T> g) {
        return obj -> g.apply((EndpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointConfiguration> {
        /**
         * <p>
         * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the
         * Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP
         * address allocation ID. For EC2 instances, this is the EC2 instance ID.
         * </p>
         * <p>
         * An Application Load Balancer can be either internal or internet-facing.
         * </p>
         * 
         * @param endpointId
         *        An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this
         *        is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is
         *        the Elastic IP address allocation ID. For EC2 instances, this is the EC2 instance ID. </p>
         *        <p>
         *        An Application Load Balancer can be either internal or internet-facing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global
         * Accelerator to route traffic based on proportions that you specify. For example, you might specify endpoint
         * weights of 4, 5, 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the
         * first endpoint, 5/20 is routed both to the second and third endpoints, and 6/20 is routed to the last
         * endpoint. For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html"
         * >Endpoint Weights</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param weight
         *        The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global
         *        Accelerator to route traffic based on proportions that you specify. For example, you might specify
         *        endpoint weights of 4, 5, 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is
         *        routed to the first endpoint, 5/20 is routed both to the second and third endpoints, and 6/20 is
         *        routed to the last endpoint. For more information, see <a href=
         *        "https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html"
         *        >Endpoint Weights</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);

        /**
         * <p>
         * Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint. The
         * value is true or false. The default value is true for new accelerators.
         * </p>
         * <p>
         * If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request
         * header as traffic travels to applications on the Application Load Balancer endpoint fronted by the
         * accelerator.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html"> Preserve
         * Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param clientIPPreservationEnabled
         *        Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
         *        The value is true or false. The default value is true for new accelerators. </p>
         *        <p>
         *        If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code>
         *        request header as traffic travels to applications on the Application Load Balancer endpoint fronted by
         *        the accelerator.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html">
         *        Preserve Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIPPreservationEnabled(Boolean clientIPPreservationEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private Integer weight;

        private Boolean clientIPPreservationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfiguration model) {
            endpointId(model.endpointId);
            weight(model.weight);
            clientIPPreservationEnabled(model.clientIPPreservationEnabled);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final Integer getWeight() {
            return weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        public final Boolean getClientIPPreservationEnabled() {
            return clientIPPreservationEnabled;
        }

        @Override
        public final Builder clientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
            return this;
        }

        public final void setClientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
        }

        @Override
        public EndpointConfiguration build() {
            return new EndpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
