/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of an accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceleratorAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AcceleratorAttributes.Builder, AcceleratorAttributes> {
    private static final SdkField<Boolean> FLOW_LOGS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AcceleratorAttributes::flowLogsEnabled)).setter(setter(Builder::flowLogsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsEnabled").build()).build();

    private static final SdkField<String> FLOW_LOGS_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceleratorAttributes::flowLogsS3Bucket)).setter(setter(Builder::flowLogsS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsS3Bucket").build()).build();

    private static final SdkField<String> FLOW_LOGS_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceleratorAttributes::flowLogsS3Prefix)).setter(setter(Builder::flowLogsS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsS3Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_LOGS_ENABLED_FIELD,
            FLOW_LOGS_S3_BUCKET_FIELD, FLOW_LOGS_S3_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean flowLogsEnabled;

    private final String flowLogsS3Bucket;

    private final String flowLogsS3Prefix;

    private AcceleratorAttributes(BuilderImpl builder) {
        this.flowLogsEnabled = builder.flowLogsEnabled;
        this.flowLogsS3Bucket = builder.flowLogsS3Bucket;
        this.flowLogsS3Prefix = builder.flowLogsS3Prefix;
    }

    /**
     * <p>
     * Indicates whether flow logs are enabled. The default value is false. If the value is true,
     * <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow
     * Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     * </p>
     * 
     * @return Indicates whether flow logs are enabled. The default value is false. If the value is true,
     *         <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html"
     *         >Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     */
    public Boolean flowLogsEnabled() {
        return flowLogsEnabled;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
     * <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission
     * to write to the bucket.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code>
     *         is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator
     *         permission to write to the bucket.
     */
    public String flowLogsS3Bucket() {
        return flowLogsS3Bucket;
    }

    /**
     * <p>
     * The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
     * <code>FlowLogsEnabled</code> is <code>true</code>. If you don’t specify a prefix, the flow logs are stored in the
     * root of the bucket.
     * </p>
     * 
     * @return The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
     *         <code>FlowLogsEnabled</code> is <code>true</code>. If you don’t specify a prefix, the flow logs are
     *         stored in the root of the bucket.
     */
    public String flowLogsS3Prefix() {
        return flowLogsS3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowLogsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogsS3Prefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceleratorAttributes)) {
            return false;
        }
        AcceleratorAttributes other = (AcceleratorAttributes) obj;
        return Objects.equals(flowLogsEnabled(), other.flowLogsEnabled())
                && Objects.equals(flowLogsS3Bucket(), other.flowLogsS3Bucket())
                && Objects.equals(flowLogsS3Prefix(), other.flowLogsS3Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AcceleratorAttributes").add("FlowLogsEnabled", flowLogsEnabled())
                .add("FlowLogsS3Bucket", flowLogsS3Bucket()).add("FlowLogsS3Prefix", flowLogsS3Prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowLogsEnabled":
            return Optional.ofNullable(clazz.cast(flowLogsEnabled()));
        case "FlowLogsS3Bucket":
            return Optional.ofNullable(clazz.cast(flowLogsS3Bucket()));
        case "FlowLogsS3Prefix":
            return Optional.ofNullable(clazz.cast(flowLogsS3Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceleratorAttributes, T> g) {
        return obj -> g.apply((AcceleratorAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceleratorAttributes> {
        /**
         * <p>
         * Indicates whether flow logs are enabled. The default value is false. If the value is true,
         * <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow
         * Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param flowLogsEnabled
         *        Indicates whether flow logs are enabled. The default value is false. If the value is true,
         *        <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html"
         *        >Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogsEnabled(Boolean flowLogsEnabled);

        /**
         * <p>
         * The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
         * <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator
         * permission to write to the bucket.
         * </p>
         * 
         * @param flowLogsS3Bucket
         *        The name of the Amazon S3 bucket for the flow logs. Attribute is required if
         *        <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that
         *        grants AWS Global Accelerator permission to write to the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogsS3Bucket(String flowLogsS3Bucket);

        /**
         * <p>
         * The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
         * <code>FlowLogsEnabled</code> is <code>true</code>. If you don’t specify a prefix, the flow logs are stored in
         * the root of the bucket.
         * </p>
         * 
         * @param flowLogsS3Prefix
         *        The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
         *        <code>FlowLogsEnabled</code> is <code>true</code>. If you don’t specify a prefix, the flow logs are
         *        stored in the root of the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogsS3Prefix(String flowLogsS3Prefix);
    }

    static final class BuilderImpl implements Builder {
        private Boolean flowLogsEnabled;

        private String flowLogsS3Bucket;

        private String flowLogsS3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceleratorAttributes model) {
            flowLogsEnabled(model.flowLogsEnabled);
            flowLogsS3Bucket(model.flowLogsS3Bucket);
            flowLogsS3Prefix(model.flowLogsS3Prefix);
        }

        public final Boolean getFlowLogsEnabled() {
            return flowLogsEnabled;
        }

        @Override
        public final Builder flowLogsEnabled(Boolean flowLogsEnabled) {
            this.flowLogsEnabled = flowLogsEnabled;
            return this;
        }

        public final void setFlowLogsEnabled(Boolean flowLogsEnabled) {
            this.flowLogsEnabled = flowLogsEnabled;
        }

        public final String getFlowLogsS3Bucket() {
            return flowLogsS3Bucket;
        }

        @Override
        public final Builder flowLogsS3Bucket(String flowLogsS3Bucket) {
            this.flowLogsS3Bucket = flowLogsS3Bucket;
            return this;
        }

        public final void setFlowLogsS3Bucket(String flowLogsS3Bucket) {
            this.flowLogsS3Bucket = flowLogsS3Bucket;
        }

        public final String getFlowLogsS3Prefix() {
            return flowLogsS3Prefix;
        }

        @Override
        public final Builder flowLogsS3Prefix(String flowLogsS3Prefix) {
            this.flowLogsS3Prefix = flowLogsS3Prefix;
            return this;
        }

        public final void setFlowLogsS3Prefix(String flowLogsS3Prefix) {
            this.flowLogsS3Prefix = flowLogsS3Prefix;
        }

        @Override
        public AcceleratorAttributes build() {
            return new AcceleratorAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
