/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;

/**
 * Service client for accessing AWS Global Accelerator asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS Global Accelerator</fullname>
 * <p>
 * This is the <i>AWS Global Accelerator API Reference</i>. This guide is for developers who need detailed information
 * about AWS Global Accelerator API actions, data types, and errors. For more information about Global Accelerator
 * features, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/Welcome.html">AWS Global
 * Accelerator Developer Guide</a>.
 * </p>
 * <p>
 * AWS Global Accelerator is a network layer service in which you create accelerators to improve availability and
 * performance for internet applications used by a global audience.
 * </p>
 * <important>
 * <p>
 * You must specify the US-West-2 (Oregon) Region to create or update accelerators.
 * </p>
 * </important>
 * <p>
 * Global Accelerator provides you with static IP addresses that you associate with your accelerator. These IP addresses
 * are anycast from the AWS edge network and distribute incoming application traffic across multiple endpoint resources
 * in multiple AWS Regions, which increases the availability of your applications. Endpoints can be Elastic IP
 * addresses, Network Load Balancers, and Application Load Balancers that are located in one AWS Region or multiple
 * Regions.
 * </p>
 * <p>
 * Global Accelerator uses the AWS global network to route traffic to the optimal regional endpoint based on health,
 * client location, and policies that you configure. The service reacts instantly to changes in health or configuration
 * to ensure that internet traffic from clients is directed to only healthy endpoints.
 * </p>
 * <p>
 * Global Accelerator includes components that work together to help you improve performance and availability for your
 * applications:
 * </p>
 * <dl>
 * <dt>Static IP address</dt>
 * <dd>
 * <p>
 * AWS Global Accelerator provides you with a set of static IP addresses which are anycast from the AWS edge network and
 * serve as the single fixed entry points for your clients. If you already have Elastic Load Balancing or Elastic IP
 * address resources set up for your applications, you can easily add those to Global Accelerator to allow the resources
 * to be accessed by a Global Accelerator static IP address.
 * </p>
 * </dd>
 * <dt>Accelerator</dt>
 * <dd>
 * <p>
 * An accelerator directs traffic to optimal endpoints over the AWS global network to improve availability and
 * performance for your internet applications that have a global audience. Each accelerator includes one or more
 * listeners.
 * </p>
 * </dd>
 * <dt>Network zone</dt>
 * <dd>
 * <p>
 * A network zone services the static IP addresses for your accelerator from a unique IP subnet. Similar to an AWS
 * Availability Zone, a network zone is an isolated unit with its own set of physical infrastructure. When you configure
 * an accelerator, Global Accelerator allocates two IPv4 addresses for it. If one IP address from a network zone becomes
 * unavailable due to IP address blocking by certain client networks, or network disruptions, then client applications
 * can retry on the healthy static IP address from the other isolated network zone.
 * </p>
 * </dd>
 * <dt>Listener</dt>
 * <dd>
 * <p>
 * A listener processes inbound connections from clients to Global Accelerator, based on the protocol and port that you
 * configure. Each listener has one or more endpoint groups associated with it, and traffic is forwarded to endpoints in
 * one of the groups. You associate endpoint groups with listeners by specifying the Regions that you want to distribute
 * traffic to. Traffic is distributed to optimal endpoints within the endpoint groups associated with a listener.
 * </p>
 * </dd>
 * <dt>Endpoint group</dt>
 * <dd>
 * <p>
 * Each endpoint group is associated with a specific AWS Region. Endpoint groups include one or more endpoints in the
 * Region. You can increase or reduce the percentage of traffic that would be otherwise directed to an endpoint group by
 * adjusting a setting called a <i>traffic dial</i>. The traffic dial lets you easily do performance testing or
 * blue/green deployment testing for new releases across different AWS Regions, for example.
 * </p>
 * </dd>
 * <dt>Endpoint</dt>
 * <dd>
 * <p>
 * An endpoint is an Elastic IP address, Network Load Balancer, or Application Load Balancer. Traffic is routed to
 * endpoints based on several factors, including the geo-proximity to the user, the health of the endpoint, and the
 * configuration options that you choose, such as endpoint weights. For each endpoint, you can configure weights, which
 * are numbers that you can use to specify the proportion of traffic to route to each one. This can be useful, for
 * example, to do performance testing within a Region.
 * </p>
 * </dd>
 * </dl>
 */
@Generated("software.amazon.awssdk:codegen")
public interface GlobalAcceleratorAsyncClient extends SdkClient {
    String SERVICE_NAME = "globalaccelerator";

    /**
     * Create a {@link GlobalAcceleratorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GlobalAcceleratorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GlobalAcceleratorAsyncClient}.
     */
    static GlobalAcceleratorAsyncClientBuilder builder() {
        return new DefaultGlobalAcceleratorAsyncClientBuilder();
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers. To see
     * an AWS CLI example of creating an accelerator, scroll down to <b>Example</b>.
     * </p>
     * <important>
     * <p>
     * You must specify the US-West-2 (Oregon) Region to create or update accelerators.
     * </p>
     * </important>
     *
     * @param createAcceleratorRequest
     * @return A Java Future containing the result of the CreateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAcceleratorResponse> createAccelerator(CreateAcceleratorRequest createAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers. To see
     * an AWS CLI example of creating an accelerator, scroll down to <b>Example</b>.
     * </p>
     * <important>
     * <p>
     * You must specify the US-West-2 (Oregon) Region to create or update accelerators.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAcceleratorRequest#builder()}
     * </p>
     *
     * @param createAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link CreateAcceleratorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAcceleratorResponse> createAccelerator(
            Consumer<CreateAcceleratorRequest.Builder> createAcceleratorRequest) {
        return createAccelerator(CreateAcceleratorRequest.builder().applyMutation(createAcceleratorRequest).build());
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS
     * Region. To see an AWS CLI example of creating an endpoint group, scroll down to <b>Example</b>.
     * </p>
     *
     * @param createEndpointGroupRequest
     * @return A Java Future containing the result of the CreateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointGroupResponse> createEndpointGroup(
            CreateEndpointGroupRequest createEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS
     * Region. To see an AWS CLI example of creating an endpoint group, scroll down to <b>Example</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointGroupRequest#builder()}
     * </p>
     *
     * @param createEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointGroupResponse> createEndpointGroup(
            Consumer<CreateEndpointGroupRequest.Builder> createEndpointGroupRequest) {
        return createEndpointGroup(CreateEndpointGroupRequest.builder().applyMutation(createEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify. To see an AWS CLI example of
     * creating a listener, scroll down to <b>Example</b>.
     * </p>
     *
     * @param createListenerRequest
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify. To see an AWS CLI example of
     * creating a listener, scroll down to <b>Example</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateListenerRequest#builder()}
     * </p>
     *
     * @param createListenerRequest
     *        A {@link Consumer} that will call methods on {@link CreateListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(Consumer<CreateListenerRequest.Builder> createListenerRequest) {
        return createListener(CreateListenerRequest.builder().applyMutation(createListenerRequest).build());
    }

    /**
     * <p>
     * Delete an accelerator. Note: before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups).
     * </p>
     *
     * @param deleteAcceleratorRequest
     * @return A Java Future containing the result of the DeleteAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAcceleratorResponse> deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an accelerator. Note: before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAcceleratorRequest#builder()}
     * </p>
     *
     * @param deleteAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAcceleratorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAcceleratorResponse> deleteAccelerator(
            Consumer<DeleteAcceleratorRequest.Builder> deleteAcceleratorRequest) {
        return deleteAccelerator(DeleteAcceleratorRequest.builder().applyMutation(deleteAcceleratorRequest).build());
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     *
     * @param deleteEndpointGroupRequest
     * @return A Java Future containing the result of the DeleteEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointGroupResponse> deleteEndpointGroup(
            DeleteEndpointGroupRequest deleteEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointGroupRequest#builder()}
     * </p>
     *
     * @param deleteEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointGroupResponse> deleteEndpointGroup(
            Consumer<DeleteEndpointGroupRequest.Builder> deleteEndpointGroupRequest) {
        return deleteEndpointGroup(DeleteEndpointGroupRequest.builder().applyMutation(deleteEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     *
     * @param deleteListenerRequest
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListenerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListenerRequest#builder()}
     * </p>
     *
     * @param deleteListenerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(Consumer<DeleteListenerRequest.Builder> deleteListenerRequest) {
        return deleteListener(DeleteListenerRequest.builder().applyMutation(deleteListenerRequest).build());
    }

    /**
     * <p>
     * Describe an accelerator. To see an AWS CLI example of describing an accelerator, scroll down to <b>Example</b>.
     * </p>
     *
     * @param describeAcceleratorRequest
     * @return A Java Future containing the result of the DescribeAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorResponse> describeAccelerator(
            DescribeAcceleratorRequest describeAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an accelerator. To see an AWS CLI example of describing an accelerator, scroll down to <b>Example</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAcceleratorRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorResponse> describeAccelerator(
            Consumer<DescribeAcceleratorRequest.Builder> describeAcceleratorRequest) {
        return describeAccelerator(DescribeAcceleratorRequest.builder().applyMutation(describeAcceleratorRequest).build());
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     * @return A Java Future containing the result of the DescribeAcceleratorAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAcceleratorAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorAttributesResponse> describeAcceleratorAttributes(
            DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorAttributesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAcceleratorAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAcceleratorAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorAttributesResponse> describeAcceleratorAttributes(
            Consumer<DescribeAcceleratorAttributesRequest.Builder> describeAcceleratorAttributesRequest) {
        return describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest.builder()
                .applyMutation(describeAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     *
     * @param describeEndpointGroupRequest
     * @return A Java Future containing the result of the DescribeEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointGroupResponse> describeEndpointGroup(
            DescribeEndpointGroupRequest describeEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointGroupRequest#builder()}
     * </p>
     *
     * @param describeEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointGroupResponse> describeEndpointGroup(
            Consumer<DescribeEndpointGroupRequest.Builder> describeEndpointGroupRequest) {
        return describeEndpointGroup(DescribeEndpointGroupRequest.builder().applyMutation(describeEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     *
     * @param describeListenerRequest
     * @return A Java Future containing the result of the DescribeListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerResponse> describeListener(DescribeListenerRequest describeListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeListenerRequest#builder()}
     * </p>
     *
     * @param describeListenerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerResponse> describeListener(
            Consumer<DescribeListenerRequest.Builder> describeListenerRequest) {
        return describeListener(DescribeListenerRequest.builder().applyMutation(describeListenerRequest).build());
    }

    /**
     * <p>
     * List the accelerators for an AWS account.
     * </p>
     *
     * @param listAcceleratorsRequest
     * @return A Java Future containing the result of the ListAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceleratorsResponse> listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the accelerators for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceleratorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListAcceleratorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceleratorsResponse> listAccelerators(
            Consumer<ListAcceleratorsRequest.Builder> listAcceleratorsRequest) {
        return listAccelerators(ListAcceleratorsRequest.builder().applyMutation(listAcceleratorsRequest).build());
    }

    /**
     * <p>
     * List the accelerators for an AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceleratorsResponse> listAccelerators() {
        return listAccelerators(ListAcceleratorsRequest.builder().build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     *
     * @param listEndpointGroupsRequest
     * @return A Java Future containing the result of the ListEndpointGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListEndpointGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointGroupsResponse> listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEndpointGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListEndpointGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointGroupsResponse> listEndpointGroups(
            Consumer<ListEndpointGroupsRequest.Builder> listEndpointGroupsRequest) {
        return listEndpointGroups(ListEndpointGroupsRequest.builder().applyMutation(listEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     *
     * @param listListenersRequest
     * @return A Java Future containing the result of the ListListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListListeners
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListListenersResponse> listListeners(ListListenersRequest listListenersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListListenersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListListeners
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListListenersResponse> listListeners(Consumer<ListListenersRequest.Builder> listListenersRequest) {
        return listListeners(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * Update an accelerator. To see an AWS CLI example of updating an accelerator, scroll down to <b>Example</b>.
     * </p>
     * <important>
     * <p>
     * You must specify the US-West-2 (Oregon) Region to create or update accelerators.
     * </p>
     * </important>
     *
     * @param updateAcceleratorRequest
     * @return A Java Future containing the result of the UpdateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorResponse> updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an accelerator. To see an AWS CLI example of updating an accelerator, scroll down to <b>Example</b>.
     * </p>
     * <important>
     * <p>
     * You must specify the US-West-2 (Oregon) Region to create or update accelerators.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAcceleratorRequest#builder()}
     * </p>
     *
     * @param updateAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAcceleratorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAccelerator
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorResponse> updateAccelerator(
            Consumer<UpdateAcceleratorRequest.Builder> updateAcceleratorRequest) {
        return updateAccelerator(UpdateAcceleratorRequest.builder().applyMutation(updateAcceleratorRequest).build());
    }

    /**
     * <p>
     * Update the attributes for an accelerator. To see an AWS CLI example of updating an accelerator to enable flow
     * logs, scroll down to <b>Example</b>.
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     * @return A Java Future containing the result of the UpdateAcceleratorAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAcceleratorAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorAttributesResponse> updateAcceleratorAttributes(
            UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the attributes for an accelerator. To see an AWS CLI example of updating an accelerator to enable flow
     * logs, scroll down to <b>Example</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAcceleratorAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAcceleratorAttributesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateAcceleratorAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAcceleratorAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorAttributesResponse> updateAcceleratorAttributes(
            Consumer<UpdateAcceleratorAttributesRequest.Builder> updateAcceleratorAttributesRequest) {
        return updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest.builder()
                .applyMutation(updateAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Update an endpoint group. To see an AWS CLI example of updating an endpoint group, scroll down to <b>Example</b>.
     * </p>
     *
     * @param updateEndpointGroupRequest
     * @return A Java Future containing the result of the UpdateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointGroupResponse> updateEndpointGroup(
            UpdateEndpointGroupRequest updateEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an endpoint group. To see an AWS CLI example of updating an endpoint group, scroll down to <b>Example</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointGroupRequest#builder()}
     * </p>
     *
     * @param updateEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateEndpointGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointGroupResponse> updateEndpointGroup(
            Consumer<UpdateEndpointGroupRequest.Builder> updateEndpointGroupRequest) {
        return updateEndpointGroup(UpdateEndpointGroupRequest.builder().applyMutation(updateEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     *
     * @param updateListenerRequest
     * @return A Java Future containing the result of the UpdateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateListenerResponse> updateListener(UpdateListenerRequest updateListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateListenerRequest#builder()}
     * </p>
     *
     * @param updateListenerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for AWS Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an AWS Global Accelerator
     *         limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateListener
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateListenerResponse> updateListener(Consumer<UpdateListenerRequest.Builder> updateListenerRequest) {
        return updateListener(UpdateListenerRequest.builder().applyMutation(updateListenerRequest).build());
    }
}
