/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteVaultLockRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, CompleteVaultLockRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteVaultLockRequest.getter(CompleteVaultLockRequest::accountId)).setter(CompleteVaultLockRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(), DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())}).build();
    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteVaultLockRequest.getter(CompleteVaultLockRequest::vaultName)).setter(CompleteVaultLockRequest.setter(Builder::vaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vaultName").build()}).build();
    private static final SdkField<String> LOCK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteVaultLockRequest.getter(CompleteVaultLockRequest::lockId)).setter(CompleteVaultLockRequest.setter(Builder::lockId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("lockId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, VAULT_NAME_FIELD, LOCK_ID_FIELD));
    private final String accountId;
    private final String vaultName;
    private final String lockId;

    private CompleteVaultLockRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.lockId = builder.lockId;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String lockId() {
        return this.lockId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteVaultLockRequest)) {
            return false;
        }
        CompleteVaultLockRequest other = (CompleteVaultLockRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.lockId(), other.lockId());
    }

    public String toString() {
        return ToString.builder((String)"CompleteVaultLockRequest").add("AccountId", (Object)this.accountId()).add("VaultName", (Object)this.vaultName()).add("LockId", (Object)this.lockId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "lockId": {
                return Optional.ofNullable(clazz.cast(this.lockId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteVaultLockRequest, T> g) {
        return obj -> g.apply((CompleteVaultLockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String lockId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteVaultLockRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.lockId(model.lockId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getLockId() {
            return this.lockId;
        }

        @Override
        public final Builder lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        public final void setLockId(String lockId) {
            this.lockId = lockId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteVaultLockRequest build() {
            return new CompleteVaultLockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteVaultLockRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder lockId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

