/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a provisioned capacity unit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedCapacityDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedCapacityDescription.Builder, ProvisionedCapacityDescription> {
    private static final SdkField<String> CAPACITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityId").getter(getter(ProvisionedCapacityDescription::capacityId))
            .setter(setter(Builder::capacityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityId").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDate").getter(getter(ProvisionedCapacityDescription::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationDate").getter(getter(ProvisionedCapacityDescription::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_ID_FIELD,
            START_DATE_FIELD, EXPIRATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityId;

    private final String startDate;

    private final String expirationDate;

    private ProvisionedCapacityDescription(BuilderImpl builder) {
        this.capacityId = builder.capacityId;
        this.startDate = builder.startDate;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * The ID that identifies the provisioned capacity unit.
     * </p>
     * 
     * @return The ID that identifies the provisioned capacity unit.
     */
    public final String capacityId() {
        return capacityId;
    }

    /**
     * <p>
     * The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).
     */
    public final String expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityId());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedCapacityDescription)) {
            return false;
        }
        ProvisionedCapacityDescription other = (ProvisionedCapacityDescription) obj;
        return Objects.equals(capacityId(), other.capacityId()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(expirationDate(), other.expirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedCapacityDescription").add("CapacityId", capacityId()).add("StartDate", startDate())
                .add("ExpirationDate", expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityId":
            return Optional.ofNullable(clazz.cast(capacityId()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityId", CAPACITY_ID_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedCapacityDescription, T> g) {
        return obj -> g.apply((ProvisionedCapacityDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedCapacityDescription> {
        /**
         * <p>
         * The ID that identifies the provisioned capacity unit.
         * </p>
         * 
         * @param capacityId
         *        The ID that identifies the provisioned capacity unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityId(String capacityId);

        /**
         * <p>
         * The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param startDate
         *        The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param expirationDate
         *        The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(String expirationDate);
    }

    static final class BuilderImpl implements Builder {
        private String capacityId;

        private String startDate;

        private String expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedCapacityDescription model) {
            capacityId(model.capacityId);
            startDate(model.startDate);
            expirationDate(model.expirationDate);
        }

        public final String getCapacityId() {
            return capacityId;
        }

        public final void setCapacityId(String capacityId) {
            this.capacityId = capacityId;
        }

        @Override
        public final Builder capacityId(String capacityId) {
            this.capacityId = capacityId;
            return this;
        }

        public final String getStartDate() {
            return startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public ProvisionedCapacityDescription build() {
            return new ProvisionedCapacityDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
