/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionCode {
    ARCHIVE_RETRIEVAL("ArchiveRetrieval"),
    INVENTORY_RETRIEVAL("InventoryRetrieval"),
    SELECT("Select"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionCode> VALUE_MAP;
    private final String value;

    private ActionCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionCode> knownValues() {
        EnumSet<ActionCode> knownValues = EnumSet.allOf(ActionCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionCode.class, ActionCode::toString);
    }
}

