/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, ListJobsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(ListJobsRequest.getter(ListJobsRequest::accountId)).setter(ListJobsRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(), DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())}).build();
    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vaultName").getter(ListJobsRequest.getter(ListJobsRequest::vaultName)).setter(ListJobsRequest.setter(Builder::vaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vaultName").build()}).build();
    private static final SdkField<String> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("limit").getter(ListJobsRequest.getter(ListJobsRequest::limit)).setter(ListJobsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("marker").getter(ListJobsRequest.getter(ListJobsRequest::marker)).setter(ListJobsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()}).build();
    private static final SdkField<String> STATUSCODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statuscode").getter(ListJobsRequest.getter(ListJobsRequest::statuscode)).setter(ListJobsRequest.setter(Builder::statuscode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statuscode").build()}).build();
    private static final SdkField<String> COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("completed").getter(ListJobsRequest.getter(ListJobsRequest::completed)).setter(ListJobsRequest.setter(Builder::completed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, VAULT_NAME_FIELD, LIMIT_FIELD, MARKER_FIELD, STATUSCODE_FIELD, COMPLETED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListJobsRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String vaultName;
    private final String limit;
    private final String marker;
    private final String statuscode;
    private final String completed;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.statuscode = builder.statuscode;
        this.completed = builder.completed;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String vaultName() {
        return this.vaultName;
    }

    public final String limit() {
        return this.limit;
    }

    public final String marker() {
        return this.marker;
    }

    public final String statuscode() {
        return this.statuscode;
    }

    public final String completed() {
        return this.completed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.statuscode());
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.statuscode(), other.statuscode()) && Objects.equals(this.completed(), other.completed());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobsRequest").add("AccountId", (Object)this.accountId()).add("VaultName", (Object)this.vaultName()).add("Limit", (Object)this.limit()).add("Marker", (Object)this.marker()).add("Statuscode", (Object)this.statuscode()).add("Completed", (Object)this.completed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "statuscode": {
                return Optional.ofNullable(clazz.cast(this.statuscode()));
            }
            case "completed": {
                return Optional.ofNullable(clazz.cast(this.completed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("vaultName", VAULT_NAME_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("marker", MARKER_FIELD);
        map.put("statuscode", STATUSCODE_FIELD);
        map.put("completed", COMPLETED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobsRequest, T> g) {
        return obj -> g.apply((ListJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String limit;
        private String marker;
        private String statuscode;
        private String completed;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.limit(model.limit);
            this.marker(model.marker);
            this.statuscode(model.statuscode);
            this.completed(model.completed);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final String getLimit() {
            return this.limit;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getStatuscode() {
            return this.statuscode;
        }

        public final void setStatuscode(String statuscode) {
            this.statuscode = statuscode;
        }

        @Override
        public final Builder statuscode(String statuscode) {
            this.statuscode = statuscode;
            return this;
        }

        public final String getCompleted() {
            return this.completed;
        }

        public final void setCompleted(String completed) {
            this.completed = completed;
        }

        @Override
        public final Builder completed(String completed) {
            this.completed = completed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder limit(String var1);

        public Builder marker(String var1);

        public Builder statuscode(String var1);

        public Builder completed(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

