/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.VaultAccessPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVaultAccessPolicyResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, GetVaultAccessPolicyResponse> {
    private static final SdkField<VaultAccessPolicy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policy").getter(GetVaultAccessPolicyResponse.getter(GetVaultAccessPolicyResponse::policy)).setter(GetVaultAccessPolicyResponse.setter(Builder::policy)).constructor(VaultAccessPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policy", POLICY_FIELD);
        }
    });
    private final VaultAccessPolicy policy;

    private GetVaultAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
    }

    public final VaultAccessPolicy policy() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVaultAccessPolicyResponse)) {
            return false;
        }
        GetVaultAccessPolicyResponse other = (GetVaultAccessPolicyResponse)((Object)obj);
        return Objects.equals(this.policy(), other.policy());
    }

    public final String toString() {
        return ToString.builder((String)"GetVaultAccessPolicyResponse").add("Policy", (Object)this.policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetVaultAccessPolicyResponse, T> g) {
        return obj -> g.apply((GetVaultAccessPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private VaultAccessPolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVaultAccessPolicyResponse model) {
            super(model);
            this.policy(model.policy);
        }

        public final VaultAccessPolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        public final void setPolicy(VaultAccessPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(VaultAccessPolicy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public GetVaultAccessPolicyResponse build() {
            return new GetVaultAccessPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVaultAccessPolicyResponse> {
        public Builder policy(VaultAccessPolicy var1);

        default public Builder policy(Consumer<VaultAccessPolicy.Builder> policy) {
            return this.policy((VaultAccessPolicy)((VaultAccessPolicy.Builder)VaultAccessPolicy.builder().applyMutation(policy)).build());
        }
    }
}

