/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.glacier.DefaultGlacierClientBuilder;
import software.amazon.awssdk.services.glacier.GlacierClientBuilder;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultResponse;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.CreateVaultRequest;
import software.amazon.awssdk.services.glacier.model.CreateVaultResponse;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultResponse;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobResponse;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.GlacierException;
import software.amazon.awssdk.services.glacier.model.InitiateJobRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobResponse;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.InsufficientCapacityException;
import software.amazon.awssdk.services.glacier.model.InvalidParameterValueException;
import software.amazon.awssdk.services.glacier.model.LimitExceededException;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;
import software.amazon.awssdk.services.glacier.model.MissingParameterValueException;
import software.amazon.awssdk.services.glacier.model.PolicyEnforcedException;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultResponse;
import software.amazon.awssdk.services.glacier.model.RequestTimeoutException;
import software.amazon.awssdk.services.glacier.model.ResourceNotFoundException;
import software.amazon.awssdk.services.glacier.model.ServiceUnavailableException;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse;
import software.amazon.awssdk.services.glacier.paginators.ListJobsIterable;
import software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsIterable;
import software.amazon.awssdk.services.glacier.paginators.ListPartsIterable;
import software.amazon.awssdk.services.glacier.paginators.ListVaultsIterable;
import software.amazon.awssdk.services.glacier.waiters.GlacierWaiter;

@SdkPublicApi
@ThreadSafe
public interface GlacierClient
extends SdkClient {
    public static final String SERVICE_NAME = "glacier";
    public static final String SERVICE_METADATA_ID = "glacier";

    public static GlacierClient create() {
        return (GlacierClient)GlacierClient.builder().build();
    }

    public static GlacierClientBuilder builder() {
        return new DefaultGlacierClientBuilder();
    }

    default public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AbortMultipartUploadResponse abortMultipartUpload(Consumer<AbortMultipartUploadRequest.Builder> abortMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.abortMultipartUpload((AbortMultipartUploadRequest)((Object)((AbortMultipartUploadRequest.Builder)AbortMultipartUploadRequest.builder().applyMutation(abortMultipartUploadRequest)).build()));
    }

    default public AbortVaultLockResponse abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AbortVaultLockResponse abortVaultLock(Consumer<AbortVaultLockRequest.Builder> abortVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.abortVaultLock((AbortVaultLockRequest)((Object)((AbortVaultLockRequest.Builder)AbortVaultLockRequest.builder().applyMutation(abortVaultLockRequest)).build()));
    }

    default public AddTagsToVaultResponse addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AddTagsToVaultResponse addTagsToVault(Consumer<AddTagsToVaultRequest.Builder> addTagsToVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.addTagsToVault((AddTagsToVaultRequest)((Object)((AddTagsToVaultRequest.Builder)AddTagsToVaultRequest.builder().applyMutation(addTagsToVaultRequest)).build()));
    }

    default public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CompleteMultipartUploadResponse completeMultipartUpload(Consumer<CompleteMultipartUploadRequest.Builder> completeMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.completeMultipartUpload((CompleteMultipartUploadRequest)((Object)((CompleteMultipartUploadRequest.Builder)CompleteMultipartUploadRequest.builder().applyMutation(completeMultipartUploadRequest)).build()));
    }

    default public CompleteVaultLockResponse completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CompleteVaultLockResponse completeVaultLock(Consumer<CompleteVaultLockRequest.Builder> completeVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.completeVaultLock((CompleteVaultLockRequest)((Object)((CompleteVaultLockRequest.Builder)CompleteVaultLockRequest.builder().applyMutation(completeVaultLockRequest)).build()));
    }

    default public CreateVaultResponse createVault(CreateVaultRequest createVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CreateVaultResponse createVault(Consumer<CreateVaultRequest.Builder> createVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, GlacierException {
        return this.createVault((CreateVaultRequest)((Object)((CreateVaultRequest.Builder)CreateVaultRequest.builder().applyMutation(createVaultRequest)).build()));
    }

    default public DeleteArchiveResponse deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteArchiveResponse deleteArchive(Consumer<DeleteArchiveRequest.Builder> deleteArchiveRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.deleteArchive((DeleteArchiveRequest)((Object)((DeleteArchiveRequest.Builder)DeleteArchiveRequest.builder().applyMutation(deleteArchiveRequest)).build()));
    }

    default public DeleteVaultResponse deleteVault(DeleteVaultRequest deleteVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultResponse deleteVault(Consumer<DeleteVaultRequest.Builder> deleteVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.deleteVault((DeleteVaultRequest)((Object)((DeleteVaultRequest.Builder)DeleteVaultRequest.builder().applyMutation(deleteVaultRequest)).build()));
    }

    default public DeleteVaultAccessPolicyResponse deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultAccessPolicyResponse deleteVaultAccessPolicy(Consumer<DeleteVaultAccessPolicyRequest.Builder> deleteVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.deleteVaultAccessPolicy((DeleteVaultAccessPolicyRequest)((Object)((DeleteVaultAccessPolicyRequest.Builder)DeleteVaultAccessPolicyRequest.builder().applyMutation(deleteVaultAccessPolicyRequest)).build()));
    }

    default public DeleteVaultNotificationsResponse deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultNotificationsResponse deleteVaultNotifications(Consumer<DeleteVaultNotificationsRequest.Builder> deleteVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.deleteVaultNotifications((DeleteVaultNotificationsRequest)((Object)((DeleteVaultNotificationsRequest.Builder)DeleteVaultNotificationsRequest.builder().applyMutation(deleteVaultNotificationsRequest)).build()));
    }

    default public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DescribeJobResponse describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.describeJob((DescribeJobRequest)((Object)((DescribeJobRequest.Builder)DescribeJobRequest.builder().applyMutation(describeJobRequest)).build()));
    }

    default public DescribeVaultResponse describeVault(DescribeVaultRequest describeVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DescribeVaultResponse describeVault(Consumer<DescribeVaultRequest.Builder> describeVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.describeVault((DescribeVaultRequest)((Object)((DescribeVaultRequest.Builder)DescribeVaultRequest.builder().applyMutation(describeVaultRequest)).build()));
    }

    default public GetDataRetrievalPolicyResponse getDataRetrievalPolicy() throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getDataRetrievalPolicy((GetDataRetrievalPolicyRequest)((Object)GetDataRetrievalPolicyRequest.builder().build()));
    }

    default public GetDataRetrievalPolicyResponse getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetDataRetrievalPolicyResponse getDataRetrievalPolicy(Consumer<GetDataRetrievalPolicyRequest.Builder> getDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getDataRetrievalPolicy((GetDataRetrievalPolicyRequest)((Object)((GetDataRetrievalPolicyRequest.Builder)GetDataRetrievalPolicyRequest.builder().applyMutation(getDataRetrievalPolicyRequest)).build()));
    }

    default public <ReturnT> ReturnT getJobOutput(GetJobOutputRequest getJobOutputRequest, ResponseTransformer<GetJobOutputResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getJobOutput(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest, ResponseTransformer<GetJobOutputResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getJobOutput((GetJobOutputRequest)((Object)((GetJobOutputRequest.Builder)GetJobOutputRequest.builder().applyMutation(getJobOutputRequest)).build()), responseTransformer);
    }

    default public GetJobOutputResponse getJobOutput(GetJobOutputRequest getJobOutputRequest, Path destinationPath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return (GetJobOutputResponse)((Object)this.getJobOutput(getJobOutputRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetJobOutputResponse getJobOutput(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest, Path destinationPath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getJobOutput((GetJobOutputRequest)((Object)((GetJobOutputRequest.Builder)GetJobOutputRequest.builder().applyMutation(getJobOutputRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetJobOutputResponse> getJobOutput(GetJobOutputRequest getJobOutputRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return (ResponseInputStream)this.getJobOutput(getJobOutputRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetJobOutputResponse> getJobOutput(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getJobOutput((GetJobOutputRequest)((Object)((GetJobOutputRequest.Builder)GetJobOutputRequest.builder().applyMutation(getJobOutputRequest)).build()));
    }

    default public ResponseBytes<GetJobOutputResponse> getJobOutputAsBytes(GetJobOutputRequest getJobOutputRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return (ResponseBytes)this.getJobOutput(getJobOutputRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetJobOutputResponse> getJobOutputAsBytes(Consumer<GetJobOutputRequest.Builder> getJobOutputRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getJobOutputAsBytes((GetJobOutputRequest)((Object)((GetJobOutputRequest.Builder)GetJobOutputRequest.builder().applyMutation(getJobOutputRequest)).build()));
    }

    default public GetVaultAccessPolicyResponse getVaultAccessPolicy(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultAccessPolicyResponse getVaultAccessPolicy(Consumer<GetVaultAccessPolicyRequest.Builder> getVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getVaultAccessPolicy((GetVaultAccessPolicyRequest)((Object)((GetVaultAccessPolicyRequest.Builder)GetVaultAccessPolicyRequest.builder().applyMutation(getVaultAccessPolicyRequest)).build()));
    }

    default public GetVaultLockResponse getVaultLock(GetVaultLockRequest getVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultLockResponse getVaultLock(Consumer<GetVaultLockRequest.Builder> getVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getVaultLock((GetVaultLockRequest)((Object)((GetVaultLockRequest.Builder)GetVaultLockRequest.builder().applyMutation(getVaultLockRequest)).build()));
    }

    default public GetVaultNotificationsResponse getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultNotificationsResponse getVaultNotifications(Consumer<GetVaultNotificationsRequest.Builder> getVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.getVaultNotifications((GetVaultNotificationsRequest)((Object)((GetVaultNotificationsRequest.Builder)GetVaultNotificationsRequest.builder().applyMutation(getVaultNotificationsRequest)).build()));
    }

    default public InitiateJobResponse initiateJob(InitiateJobRequest initiateJobRequest) throws ResourceNotFoundException, PolicyEnforcedException, InvalidParameterValueException, MissingParameterValueException, InsufficientCapacityException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateJobResponse initiateJob(Consumer<InitiateJobRequest.Builder> initiateJobRequest) throws ResourceNotFoundException, PolicyEnforcedException, InvalidParameterValueException, MissingParameterValueException, InsufficientCapacityException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.initiateJob((InitiateJobRequest)((Object)((InitiateJobRequest.Builder)InitiateJobRequest.builder().applyMutation(initiateJobRequest)).build()));
    }

    default public InitiateMultipartUploadResponse initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateMultipartUploadResponse initiateMultipartUpload(Consumer<InitiateMultipartUploadRequest.Builder> initiateMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.initiateMultipartUpload((InitiateMultipartUploadRequest)((Object)((InitiateMultipartUploadRequest.Builder)InitiateMultipartUploadRequest.builder().applyMutation(initiateMultipartUploadRequest)).build()));
    }

    default public InitiateVaultLockResponse initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateVaultLockResponse initiateVaultLock(Consumer<InitiateVaultLockRequest.Builder> initiateVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.initiateVaultLock((InitiateVaultLockRequest)((Object)((InitiateVaultLockRequest.Builder)InitiateVaultLockRequest.builder().applyMutation(initiateVaultLockRequest)).build()));
    }

    default public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listJobs((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().applyMutation(listJobsRequest)).build()));
    }

    default public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listJobsPaginator((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().applyMutation(listJobsRequest)).build()));
    }

    default public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListMultipartUploadsResponse listMultipartUploads(Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listMultipartUploads((ListMultipartUploadsRequest)((Object)((ListMultipartUploadsRequest.Builder)ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest)).build()));
    }

    default public ListMultipartUploadsIterable listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListMultipartUploadsIterable listMultipartUploadsPaginator(Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listMultipartUploadsPaginator((ListMultipartUploadsRequest)((Object)((ListMultipartUploadsRequest.Builder)ListMultipartUploadsRequest.builder().applyMutation(listMultipartUploadsRequest)).build()));
    }

    default public ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListPartsResponse listParts(Consumer<ListPartsRequest.Builder> listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listParts((ListPartsRequest)((Object)((ListPartsRequest.Builder)ListPartsRequest.builder().applyMutation(listPartsRequest)).build()));
    }

    default public ListPartsIterable listPartsPaginator(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListPartsIterable listPartsPaginator(Consumer<ListPartsRequest.Builder> listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listPartsPaginator((ListPartsRequest)((Object)((ListPartsRequest.Builder)ListPartsRequest.builder().applyMutation(listPartsRequest)).build()));
    }

    default public ListProvisionedCapacityResponse listProvisionedCapacity() throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listProvisionedCapacity((ListProvisionedCapacityRequest)((Object)ListProvisionedCapacityRequest.builder().build()));
    }

    default public ListProvisionedCapacityResponse listProvisionedCapacity(ListProvisionedCapacityRequest listProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListProvisionedCapacityResponse listProvisionedCapacity(Consumer<ListProvisionedCapacityRequest.Builder> listProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listProvisionedCapacity((ListProvisionedCapacityRequest)((Object)((ListProvisionedCapacityRequest.Builder)ListProvisionedCapacityRequest.builder().applyMutation(listProvisionedCapacityRequest)).build()));
    }

    default public ListTagsForVaultResponse listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForVaultResponse listTagsForVault(Consumer<ListTagsForVaultRequest.Builder> listTagsForVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listTagsForVault((ListTagsForVaultRequest)((Object)((ListTagsForVaultRequest.Builder)ListTagsForVaultRequest.builder().applyMutation(listTagsForVaultRequest)).build()));
    }

    default public ListVaultsResponse listVaults() throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listVaults((ListVaultsRequest)((Object)ListVaultsRequest.builder().build()));
    }

    default public ListVaultsResponse listVaults(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListVaultsResponse listVaults(Consumer<ListVaultsRequest.Builder> listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listVaults((ListVaultsRequest)((Object)((ListVaultsRequest.Builder)ListVaultsRequest.builder().applyMutation(listVaultsRequest)).build()));
    }

    default public ListVaultsIterable listVaultsPaginator() throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listVaultsPaginator((ListVaultsRequest)((Object)ListVaultsRequest.builder().build()));
    }

    default public ListVaultsIterable listVaultsPaginator(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListVaultsIterable listVaultsPaginator(Consumer<ListVaultsRequest.Builder> listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.listVaultsPaginator((ListVaultsRequest)((Object)((ListVaultsRequest.Builder)ListVaultsRequest.builder().applyMutation(listVaultsRequest)).build()));
    }

    default public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity() throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.purchaseProvisionedCapacity((PurchaseProvisionedCapacityRequest)((Object)PurchaseProvisionedCapacityRequest.builder().build()));
    }

    default public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity(Consumer<PurchaseProvisionedCapacityRequest.Builder> purchaseProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.purchaseProvisionedCapacity((PurchaseProvisionedCapacityRequest)((Object)((PurchaseProvisionedCapacityRequest.Builder)PurchaseProvisionedCapacityRequest.builder().applyMutation(purchaseProvisionedCapacityRequest)).build()));
    }

    default public RemoveTagsFromVaultResponse removeTagsFromVault(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public RemoveTagsFromVaultResponse removeTagsFromVault(Consumer<RemoveTagsFromVaultRequest.Builder> removeTagsFromVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.removeTagsFromVault((RemoveTagsFromVaultRequest)((Object)((RemoveTagsFromVaultRequest.Builder)RemoveTagsFromVaultRequest.builder().applyMutation(removeTagsFromVaultRequest)).build()));
    }

    default public SetDataRetrievalPolicyResponse setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetDataRetrievalPolicyResponse setDataRetrievalPolicy(Consumer<SetDataRetrievalPolicyRequest.Builder> setDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.setDataRetrievalPolicy((SetDataRetrievalPolicyRequest)((Object)((SetDataRetrievalPolicyRequest.Builder)SetDataRetrievalPolicyRequest.builder().applyMutation(setDataRetrievalPolicyRequest)).build()));
    }

    default public SetVaultAccessPolicyResponse setVaultAccessPolicy(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetVaultAccessPolicyResponse setVaultAccessPolicy(Consumer<SetVaultAccessPolicyRequest.Builder> setVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.setVaultAccessPolicy((SetVaultAccessPolicyRequest)((Object)((SetVaultAccessPolicyRequest.Builder)SetVaultAccessPolicyRequest.builder().applyMutation(setVaultAccessPolicyRequest)).build()));
    }

    default public SetVaultNotificationsResponse setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetVaultNotificationsResponse setVaultNotifications(Consumer<SetVaultNotificationsRequest.Builder> setVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.setVaultNotifications((SetVaultNotificationsRequest)((Object)((SetVaultNotificationsRequest.Builder)SetVaultNotificationsRequest.builder().applyMutation(setVaultNotificationsRequest)).build()));
    }

    default public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public UploadArchiveResponse uploadArchive(Consumer<UploadArchiveRequest.Builder> uploadArchiveRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.uploadArchive((UploadArchiveRequest)((Object)((UploadArchiveRequest.Builder)UploadArchiveRequest.builder().applyMutation(uploadArchiveRequest)).build()), requestBody);
    }

    default public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, Path sourcePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.uploadArchive(uploadArchiveRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public UploadArchiveResponse uploadArchive(Consumer<UploadArchiveRequest.Builder> uploadArchiveRequest, Path sourcePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.uploadArchive((UploadArchiveRequest)((Object)((UploadArchiveRequest.Builder)UploadArchiveRequest.builder().applyMutation(uploadArchiveRequest)).build()), sourcePath);
    }

    default public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public UploadMultipartPartResponse uploadMultipartPart(Consumer<UploadMultipartPartRequest.Builder> uploadMultipartPartRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.uploadMultipartPart((UploadMultipartPartRequest)((Object)((UploadMultipartPartRequest.Builder)UploadMultipartPartRequest.builder().applyMutation(uploadMultipartPartRequest)).build()), requestBody);
    }

    default public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, Path sourcePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.uploadMultipartPart(uploadMultipartPartRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public UploadMultipartPartResponse uploadMultipartPart(Consumer<UploadMultipartPartRequest.Builder> uploadMultipartPartRequest, Path sourcePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return this.uploadMultipartPart((UploadMultipartPartRequest)((Object)((UploadMultipartPartRequest.Builder)UploadMultipartPartRequest.builder().applyMutation(uploadMultipartPartRequest)).build()), sourcePath);
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"glacier");
    }

    default public GlacierWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}

