/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitiateJobResponse extends GlacierResponse implements
        ToCopyableBuilder<InitiateJobResponse.Builder, InitiateJobResponse> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(InitiateJobResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(InitiateJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-job-id").build()).build();

    private static final SdkField<String> JOB_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobOutputPath").getter(getter(InitiateJobResponse::jobOutputPath))
            .setter(setter(Builder::jobOutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-job-output-path").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, JOB_ID_FIELD,
            JOB_OUTPUT_PATH_FIELD));

    private final String location;

    private final String jobId;

    private final String jobOutputPath;

    private InitiateJobResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.jobId = builder.jobId;
        this.jobOutputPath = builder.jobOutputPath;
    }

    /**
     * <p>
     * The relative URI path of the job.
     * </p>
     * 
     * @return The relative URI path of the job.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The path to the location of where the select results are stored.
     * </p>
     * 
     * @return The path to the location of where the select results are stored.
     */
    public final String jobOutputPath() {
        return jobOutputPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutputPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateJobResponse)) {
            return false;
        }
        InitiateJobResponse other = (InitiateJobResponse) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobOutputPath(), other.jobOutputPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitiateJobResponse").add("Location", location()).add("JobId", jobId())
                .add("JobOutputPath", jobOutputPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobOutputPath":
            return Optional.ofNullable(clazz.cast(jobOutputPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitiateJobResponse, T> g) {
        return obj -> g.apply((InitiateJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, InitiateJobResponse> {
        /**
         * <p>
         * The relative URI path of the job.
         * </p>
         * 
         * @param location
         *        The relative URI path of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The path to the location of where the select results are stored.
         * </p>
         * 
         * @param jobOutputPath
         *        The path to the location of where the select results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutputPath(String jobOutputPath);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String location;

        private String jobId;

        private String jobOutputPath;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateJobResponse model) {
            super(model);
            location(model.location);
            jobId(model.jobId);
            jobOutputPath(model.jobOutputPath);
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobOutputPath() {
            return jobOutputPath;
        }

        @Override
        public final Builder jobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
            return this;
        }

        public final void setJobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
        }

        @Override
        public InitiateJobResponse build() {
            return new InitiateJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
