/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteMultipartUploadResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, CompleteMultipartUploadResponse> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(CompleteMultipartUploadResponse.getter(CompleteMultipartUploadResponse::location)).setter(CompleteMultipartUploadResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checksum").getter(CompleteMultipartUploadResponse.getter(CompleteMultipartUploadResponse::checksum)).setter(CompleteMultipartUploadResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-sha256-tree-hash").build()}).build();
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("archiveId").getter(CompleteMultipartUploadResponse.getter(CompleteMultipartUploadResponse::archiveId)).setter(CompleteMultipartUploadResponse.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-archive-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, CHECKSUM_FIELD, ARCHIVE_ID_FIELD));
    private final String location;
    private final String checksum;
    private final String archiveId;

    private CompleteMultipartUploadResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.checksum = builder.checksum;
        this.archiveId = builder.archiveId;
    }

    public String location() {
        return this.location;
    }

    public String checksum() {
        return this.checksum;
    }

    public String archiveId() {
        return this.archiveId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartUploadResponse)) {
            return false;
        }
        CompleteMultipartUploadResponse other = (CompleteMultipartUploadResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.archiveId(), other.archiveId());
    }

    public String toString() {
        return ToString.builder((String)"CompleteMultipartUploadResponse").add("Location", (Object)this.location()).add("Checksum", (Object)this.checksum()).add("ArchiveId", (Object)this.archiveId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "archiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteMultipartUploadResponse, T> g) {
        return obj -> g.apply((CompleteMultipartUploadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String location;
        private String checksum;
        private String archiveId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartUploadResponse model) {
            super(model);
            this.location(model.location);
            this.checksum(model.checksum);
            this.archiveId(model.archiveId);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public CompleteMultipartUploadResponse build() {
            return new CompleteMultipartUploadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteMultipartUploadResponse> {
        public Builder location(String var1);

        public Builder checksum(String var1);

        public Builder archiveId(String var1);
    }
}

