/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UploadListElement> {
    private static final SdkField<String> MULTIPART_UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadListElement.getter(UploadListElement::multipartUploadId)).setter(UploadListElement.setter(Builder::multipartUploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultipartUploadId").build()}).build();
    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadListElement.getter(UploadListElement::vaultARN)).setter(UploadListElement.setter(Builder::vaultARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()}).build();
    private static final SdkField<String> ARCHIVE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadListElement.getter(UploadListElement::archiveDescription)).setter(UploadListElement.setter(Builder::archiveDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveDescription").build()}).build();
    private static final SdkField<Long> PART_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UploadListElement.getter(UploadListElement::partSizeInBytes)).setter(UploadListElement.setter(Builder::partSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartSizeInBytes").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadListElement.getter(UploadListElement::creationDate)).setter(UploadListElement.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPART_UPLOAD_ID_FIELD, VAULT_ARN_FIELD, ARCHIVE_DESCRIPTION_FIELD, PART_SIZE_IN_BYTES_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String multipartUploadId;
    private final String vaultARN;
    private final String archiveDescription;
    private final Long partSizeInBytes;
    private final String creationDate;

    private UploadListElement(BuilderImpl builder) {
        this.multipartUploadId = builder.multipartUploadId;
        this.vaultARN = builder.vaultARN;
        this.archiveDescription = builder.archiveDescription;
        this.partSizeInBytes = builder.partSizeInBytes;
        this.creationDate = builder.creationDate;
    }

    public String multipartUploadId() {
        return this.multipartUploadId;
    }

    public String vaultARN() {
        return this.vaultARN;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public Long partSizeInBytes() {
        return this.partSizeInBytes;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multipartUploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadListElement)) {
            return false;
        }
        UploadListElement other = (UploadListElement)obj;
        return Objects.equals(this.multipartUploadId(), other.multipartUploadId()) && Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.archiveDescription(), other.archiveDescription()) && Objects.equals(this.partSizeInBytes(), other.partSizeInBytes()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"UploadListElement").add("MultipartUploadId", (Object)this.multipartUploadId()).add("VaultARN", (Object)this.vaultARN()).add("ArchiveDescription", (Object)this.archiveDescription()).add("PartSizeInBytes", (Object)this.partSizeInBytes()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultipartUploadId": {
                return Optional.ofNullable(clazz.cast(this.multipartUploadId()));
            }
            case "VaultARN": {
                return Optional.ofNullable(clazz.cast(this.vaultARN()));
            }
            case "ArchiveDescription": {
                return Optional.ofNullable(clazz.cast(this.archiveDescription()));
            }
            case "PartSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.partSizeInBytes()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadListElement, T> g) {
        return obj -> g.apply((UploadListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String multipartUploadId;
        private String vaultARN;
        private String archiveDescription;
        private Long partSizeInBytes;
        private String creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadListElement model) {
            this.multipartUploadId(model.multipartUploadId);
            this.vaultARN(model.vaultARN);
            this.archiveDescription(model.archiveDescription);
            this.partSizeInBytes(model.partSizeInBytes);
            this.creationDate(model.creationDate);
        }

        public final String getMultipartUploadId() {
            return this.multipartUploadId;
        }

        @Override
        public final Builder multipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
            return this;
        }

        public final void setMultipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final Long getPartSizeInBytes() {
            return this.partSizeInBytes;
        }

        @Override
        public final Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public final void setPartSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public UploadListElement build() {
            return new UploadListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UploadListElement> {
        public Builder multipartUploadId(String var1);

        public Builder vaultARN(String var1);

        public Builder archiveDescription(String var1);

        public Builder partSizeInBytes(Long var1);

        public Builder creationDate(String var1);
    }
}

