/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseProvisionedCapacityResponse extends GlacierResponse implements
        ToCopyableBuilder<PurchaseProvisionedCapacityResponse.Builder, PurchaseProvisionedCapacityResponse> {
    private static final SdkField<String> CAPACITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseProvisionedCapacityResponse::capacityId)).setter(setter(Builder::capacityId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-capacity-id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_ID_FIELD));

    private final String capacityId;

    private PurchaseProvisionedCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.capacityId = builder.capacityId;
    }

    /**
     * <p>
     * The ID that identifies the provisioned capacity unit.
     * </p>
     * 
     * @return The ID that identifies the provisioned capacity unit.
     */
    public String capacityId() {
        return capacityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseProvisionedCapacityResponse)) {
            return false;
        }
        PurchaseProvisionedCapacityResponse other = (PurchaseProvisionedCapacityResponse) obj;
        return Objects.equals(capacityId(), other.capacityId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PurchaseProvisionedCapacityResponse").add("CapacityId", capacityId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacityId":
            return Optional.ofNullable(clazz.cast(capacityId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseProvisionedCapacityResponse, T> g) {
        return obj -> g.apply((PurchaseProvisionedCapacityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseProvisionedCapacityResponse> {
        /**
         * <p>
         * The ID that identifies the provisioned capacity unit.
         * </p>
         * 
         * @param capacityId
         *        The ID that identifies the provisioned capacity unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityId(String capacityId);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String capacityId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseProvisionedCapacityResponse model) {
            super(model);
            capacityId(model.capacityId);
        }

        public final String getCapacityId() {
            return capacityId;
        }

        @Override
        public final Builder capacityId(String capacityId) {
            this.capacityId = capacityId;
            return this;
        }

        public final void setCapacityId(String capacityId) {
            this.capacityId = capacityId;
        }

        @Override
        public PurchaseProvisionedCapacityResponse build() {
            return new PurchaseProvisionedCapacityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
