/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of the part sizes of the multipart upload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartListElement implements SdkPojo, Serializable, ToCopyableBuilder<PartListElement.Builder, PartListElement> {
    private static final SdkField<String> RANGE_IN_BYTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PartListElement::rangeInBytes)).setter(setter(Builder::rangeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeInBytes").build()).build();

    private static final SdkField<String> SHA256_TREE_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PartListElement::sha256TreeHash)).setter(setter(Builder::sha256TreeHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SHA256TreeHash").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGE_IN_BYTES_FIELD,
            SHA256_TREE_HASH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rangeInBytes;

    private final String sha256TreeHash;

    private PartListElement(BuilderImpl builder) {
        this.rangeInBytes = builder.rangeInBytes;
        this.sha256TreeHash = builder.sha256TreeHash;
    }

    /**
     * <p>
     * The byte range of a part, inclusive of the upper value of the range.
     * </p>
     * 
     * @return The byte range of a part, inclusive of the upper value of the range.
     */
    public String rangeInBytes() {
        return rangeInBytes;
    }

    /**
     * <p>
     * The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never <code>null</code>.
     * </p>
     * 
     * @return The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never
     *         <code>null</code>.
     */
    public String sha256TreeHash() {
        return sha256TreeHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rangeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(sha256TreeHash());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartListElement)) {
            return false;
        }
        PartListElement other = (PartListElement) obj;
        return Objects.equals(rangeInBytes(), other.rangeInBytes()) && Objects.equals(sha256TreeHash(), other.sha256TreeHash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PartListElement").add("RangeInBytes", rangeInBytes()).add("SHA256TreeHash", sha256TreeHash())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RangeInBytes":
            return Optional.ofNullable(clazz.cast(rangeInBytes()));
        case "SHA256TreeHash":
            return Optional.ofNullable(clazz.cast(sha256TreeHash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartListElement, T> g) {
        return obj -> g.apply((PartListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartListElement> {
        /**
         * <p>
         * The byte range of a part, inclusive of the upper value of the range.
         * </p>
         * 
         * @param rangeInBytes
         *        The byte range of a part, inclusive of the upper value of the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeInBytes(String rangeInBytes);

        /**
         * <p>
         * The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never
         * <code>null</code>.
         * </p>
         * 
         * @param sha256TreeHash
         *        The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha256TreeHash(String sha256TreeHash);
    }

    static final class BuilderImpl implements Builder {
        private String rangeInBytes;

        private String sha256TreeHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PartListElement model) {
            rangeInBytes(model.rangeInBytes);
            sha256TreeHash(model.sha256TreeHash);
        }

        public final String getRangeInBytes() {
            return rangeInBytes;
        }

        @Override
        public final Builder rangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
            return this;
        }

        public final void setRangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
        }

        public final String getSha256TreeHash() {
            return sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public final void setSha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        @Override
        public PartListElement build() {
            return new PartListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
