/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;

public class ListVaultsIterable
implements SdkIterable<ListVaultsResponse> {
    private final GlacierClient client;
    private final ListVaultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVaultsIterable(GlacierClient client, ListVaultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVaultsResponseFetcher();
    }

    public Iterator<ListVaultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeVaultOutput> vaultList() {
        Function<ListVaultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vaultList() != null) {
                return response.vaultList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVaultsResponseFetcher
    implements SyncPageFetcher<ListVaultsResponse> {
        private ListVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListVaultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListVaultsResponse nextPage(ListVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListVaultsIterable.this.client.listVaults(ListVaultsIterable.this.firstRequest);
            }
            return ListVaultsIterable.this.client.listVaults((ListVaultsRequest)((Object)ListVaultsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

