/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.GlacierJobDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GlacierJobDescriptionMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> JOBDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobDescription").isBinary(false).build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<String> ARCHIVEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveId").isBinary(false).build();
    private static final MarshallingInfo<String> VAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultARN").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<Boolean> COMPLETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Completed").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").isBinary(false).build();
    private static final MarshallingInfo<Long> ARCHIVESIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveSizeInBytes").isBinary(false).build();
    private static final MarshallingInfo<Long> INVENTORYSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InventorySizeInBytes").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SNSTopic").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDate").isBinary(false).build();
    private static final MarshallingInfo<String> SHA256TREEHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SHA256TreeHash").isBinary(false).build();
    private static final MarshallingInfo<String> ARCHIVESHA256TREEHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveSHA256TreeHash").isBinary(false).build();
    private static final MarshallingInfo<String> RETRIEVALBYTERANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetrievalByteRange").isBinary(false).build();
    private static final MarshallingInfo<String> TIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tier").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INVENTORYRETRIEVALPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InventoryRetrievalParameters").isBinary(false).build();
    private static final GlacierJobDescriptionMarshaller INSTANCE = new GlacierJobDescriptionMarshaller();

    private GlacierJobDescriptionMarshaller() {
    }

    public static GlacierJobDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlacierJobDescription glacierJobDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)glacierJobDescription, (String)"glacierJobDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)glacierJobDescription.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.jobDescription(), JOBDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.actionString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.archiveId(), ARCHIVEID_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.vaultARN(), VAULTARN_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.completed(), COMPLETED_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.statusCodeString(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.archiveSizeInBytes(), ARCHIVESIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.inventorySizeInBytes(), INVENTORYSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.snsTopic(), SNSTOPIC_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.completionDate(), COMPLETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.sha256TreeHash(), SHA256TREEHASH_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.archiveSHA256TreeHash(), ARCHIVESHA256TREEHASH_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.retrievalByteRange(), RETRIEVALBYTERANGE_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.tier(), TIER_BINDING);
            protocolMarshaller.marshall((Object)glacierJobDescription.inventoryRetrievalParameters(), INVENTORYRETRIEVALPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

