/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.DataRetrievalRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DataRetrievalRuleMarshaller {
    private static final MarshallingInfo<String> STRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Strategy").isBinary(false).build();
    private static final MarshallingInfo<Long> BYTESPERHOUR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesPerHour").isBinary(false).build();
    private static final DataRetrievalRuleMarshaller INSTANCE = new DataRetrievalRuleMarshaller();

    private DataRetrievalRuleMarshaller() {
    }

    public static DataRetrievalRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DataRetrievalRule dataRetrievalRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dataRetrievalRule, (String)"dataRetrievalRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dataRetrievalRule.strategy(), STRATEGY_BINDING);
            protocolMarshaller.marshall((Object)dataRetrievalRule.bytesPerHour(), BYTESPERHOUR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

